// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Qos Traffic Profiler IP Range properties. */
@Fluent
public final class QosIpRange {
    /*
     * Start IP Address.
     */
    @JsonProperty(value = "startIP")
    private String startIp;

    /*
     * End IP Address.
     */
    @JsonProperty(value = "endIP")
    private String endIp;

    /**
     * Get the startIp property: Start IP Address.
     *
     * @return the startIp value.
     */
    public String startIp() {
        return this.startIp;
    }

    /**
     * Set the startIp property: Start IP Address.
     *
     * @param startIp the startIp value to set.
     * @return the QosIpRange object itself.
     */
    public QosIpRange withStartIp(String startIp) {
        this.startIp = startIp;
        return this;
    }

    /**
     * Get the endIp property: End IP Address.
     *
     * @return the endIp value.
     */
    public String endIp() {
        return this.endIp;
    }

    /**
     * Set the endIp property: End IP Address.
     *
     * @param endIp the endIp value to set.
     * @return the QosIpRange object itself.
     */
    public QosIpRange withEndIp(String endIp) {
        this.endIp = endIp;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
