// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Parameters that define the flow log format. */
@Fluent
public final class FlowLogFormatParameters {
    /*
     * The file type of flow log.
     */
    @JsonProperty(value = "type")
    private FlowLogFormatType type;

    /*
     * The version (revision) of the flow log.
     */
    @JsonProperty(value = "version")
    private Integer version;

    /**
     * Get the type property: The file type of flow log.
     *
     * @return the type value.
     */
    public FlowLogFormatType type() {
        return this.type;
    }

    /**
     * Set the type property: The file type of flow log.
     *
     * @param type the type value to set.
     * @return the FlowLogFormatParameters object itself.
     */
    public FlowLogFormatParameters withType(FlowLogFormatType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the version property: The version (revision) of the flow log.
     *
     * @return the version value.
     */
    public Integer version() {
        return this.version;
    }

    /**
     * Set the version property: The version (revision) of the flow log.
     *
     * @param version the version value to set.
     * @return the FlowLogFormatParameters object itself.
     */
    public FlowLogFormatParameters withVersion(Integer version) {
        this.version = version;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
