// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Configuration for intrusion detection mode and rules. */
@Fluent
public final class FirewallPolicyIntrusionDetection {
    /*
     * Intrusion detection general state.
     */
    @JsonProperty(value = "mode")
    private FirewallPolicyIntrusionDetectionStateType mode;

    /*
     * Intrusion detection configuration properties.
     */
    @JsonProperty(value = "configuration")
    private FirewallPolicyIntrusionDetectionConfiguration configuration;

    /**
     * Get the mode property: Intrusion detection general state.
     *
     * @return the mode value.
     */
    public FirewallPolicyIntrusionDetectionStateType mode() {
        return this.mode;
    }

    /**
     * Set the mode property: Intrusion detection general state.
     *
     * @param mode the mode value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection withMode(FirewallPolicyIntrusionDetectionStateType mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the configuration property: Intrusion detection configuration properties.
     *
     * @return the configuration value.
     */
    public FirewallPolicyIntrusionDetectionConfiguration configuration() {
        return this.configuration;
    }

    /**
     * Set the configuration property: Intrusion detection configuration properties.
     *
     * @param configuration the configuration value to set.
     * @return the FirewallPolicyIntrusionDetection object itself.
     */
    public FirewallPolicyIntrusionDetection withConfiguration(
        FirewallPolicyIntrusionDetectionConfiguration configuration) {
        this.configuration = configuration;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (configuration() != null) {
            configuration().validate();
        }
    }
}
