// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.fluent.models.AdminRuleCollectionInner;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Security admin configuration rule collection list result. */
@Fluent
public final class AdminRuleCollectionListResult {
    /*
     * A list of network manager security admin configuration rule collections
     */
    @JsonProperty(value = "value")
    private List<AdminRuleCollectionInner> value;

    /*
     * Gets the URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: A list of network manager security admin configuration rule collections.
     *
     * @return the value value.
     */
    public List<AdminRuleCollectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of network manager security admin configuration rule collections.
     *
     * @param value the value value to set.
     * @return the AdminRuleCollectionListResult object itself.
     */
    public AdminRuleCollectionListResult withValue(List<AdminRuleCollectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Gets the URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Gets the URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the AdminRuleCollectionListResult object itself.
     */
    public AdminRuleCollectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
