// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

/** Active connectivity configuration. */
@Fluent
public final class ActiveConnectivityConfiguration extends EffectiveConnectivityConfiguration {
    /*
     * Deployment time string.
     */
    @JsonProperty(value = "commitTime")
    private OffsetDateTime commitTime;

    /*
     * Deployment region.
     */
    @JsonProperty(value = "region")
    private String region;

    /**
     * Get the commitTime property: Deployment time string.
     *
     * @return the commitTime value.
     */
    public OffsetDateTime commitTime() {
        return this.commitTime;
    }

    /**
     * Set the commitTime property: Deployment time string.
     *
     * @param commitTime the commitTime value to set.
     * @return the ActiveConnectivityConfiguration object itself.
     */
    public ActiveConnectivityConfiguration withCommitTime(OffsetDateTime commitTime) {
        this.commitTime = commitTime;
        return this;
    }

    /**
     * Get the region property: Deployment region.
     *
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: Deployment region.
     *
     * @param region the region value to set.
     * @return the ActiveConnectivityConfiguration object itself.
     */
    public ActiveConnectivityConfiguration withRegion(String region) {
        this.region = region;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withId(String id) {
        super.withId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withConfigurationGroups(List<ConfigurationGroup> configurationGroups) {
        super.withConfigurationGroups(configurationGroups);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withConnectivityTopology(ConnectivityTopology connectivityTopology) {
        super.withConnectivityTopology(connectivityTopology);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withHubs(List<Hub> hubs) {
        super.withHubs(hubs);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withIsGlobal(IsGlobal isGlobal) {
        super.withIsGlobal(isGlobal);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withAppliesToGroups(List<ConnectivityGroupItem> appliesToGroups) {
        super.withAppliesToGroups(appliesToGroups);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public ActiveConnectivityConfiguration withDeleteExistingPeering(DeleteExistingPeering deleteExistingPeering) {
        super.withDeleteExistingPeering(deleteExistingPeering);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }
}
