// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.VpnServerConfigurationPolicyGroupMember;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters for VpnServerConfigurationPolicyGroup. */
@Fluent
public final class VpnServerConfigurationPolicyGroupProperties {
    /*
     * Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     */
    @JsonProperty(value = "isDefault")
    private Boolean isDefault;

    /*
     * Priority for VpnServerConfigurationPolicyGroup.
     */
    @JsonProperty(value = "priority")
    private Integer priority;

    /*
     * Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     */
    @JsonProperty(value = "policyMembers")
    private List<VpnServerConfigurationPolicyGroupMember> policyMembers;

    /*
     * List of references to P2SConnectionConfigurations.
     */
    @JsonProperty(value = "p2SConnectionConfigurations", access = JsonProperty.Access.WRITE_ONLY)
    private List<SubResource> p2SConnectionConfigurations;

    /*
     * The provisioning state of the VpnServerConfigurationPolicyGroup resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the isDefault property: Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     *
     * @return the isDefault value.
     */
    public Boolean isDefault() {
        return this.isDefault;
    }

    /**
     * Set the isDefault property: Shows if this is a Default VpnServerConfigurationPolicyGroup or not.
     *
     * @param isDefault the isDefault value to set.
     * @return the VpnServerConfigurationPolicyGroupProperties object itself.
     */
    public VpnServerConfigurationPolicyGroupProperties withIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    /**
     * Get the priority property: Priority for VpnServerConfigurationPolicyGroup.
     *
     * @return the priority value.
     */
    public Integer priority() {
        return this.priority;
    }

    /**
     * Set the priority property: Priority for VpnServerConfigurationPolicyGroup.
     *
     * @param priority the priority value to set.
     * @return the VpnServerConfigurationPolicyGroupProperties object itself.
     */
    public VpnServerConfigurationPolicyGroupProperties withPriority(Integer priority) {
        this.priority = priority;
        return this;
    }

    /**
     * Get the policyMembers property: Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     *
     * @return the policyMembers value.
     */
    public List<VpnServerConfigurationPolicyGroupMember> policyMembers() {
        return this.policyMembers;
    }

    /**
     * Set the policyMembers property: Multiple PolicyMembers for VpnServerConfigurationPolicyGroup.
     *
     * @param policyMembers the policyMembers value to set.
     * @return the VpnServerConfigurationPolicyGroupProperties object itself.
     */
    public VpnServerConfigurationPolicyGroupProperties withPolicyMembers(
        List<VpnServerConfigurationPolicyGroupMember> policyMembers) {
        this.policyMembers = policyMembers;
        return this;
    }

    /**
     * Get the p2SConnectionConfigurations property: List of references to P2SConnectionConfigurations.
     *
     * @return the p2SConnectionConfigurations value.
     */
    public List<SubResource> p2SConnectionConfigurations() {
        return this.p2SConnectionConfigurations;
    }

    /**
     * Get the provisioningState property: The provisioning state of the VpnServerConfigurationPolicyGroup resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (policyMembers() != null) {
            policyMembers().forEach(e -> e.validate());
        }
    }
}
