// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.SecurityRuleAccess;
import com.azure.resourcemanager.network.models.SecurityRuleDirection;
import com.azure.resourcemanager.network.models.SecurityRuleProtocol;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Network security rule. */
@Fluent
public final class SecurityRuleInner extends SubResource {
    /*
     * Properties of the security rule.
     */
    @JsonProperty(value = "properties")
    private SecurityRulePropertiesFormat innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * The type of the resource.
     */
    @JsonProperty(value = "type")
    private String type;

    /**
     * Get the innerProperties property: Properties of the security rule.
     *
     * @return the innerProperties value.
     */
    private SecurityRulePropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: The type of the resource.
     *
     * @param type the type value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withType(String type) {
        this.type = type;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SecurityRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the description property: A description for this rule. Restricted to 140 chars.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description for this rule. Restricted to 140 chars.
     *
     * @param description the description value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the protocol property: Network protocol this rule applies to.
     *
     * @return the protocol value.
     */
    public SecurityRuleProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    /**
     * Set the protocol property: Network protocol this rule applies to.
     *
     * @param protocol the protocol value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withProtocol(SecurityRuleProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    /**
     * Get the sourcePortRange property: The source port or range. Integer or range between 0 and 65535. Asterisk '*'
     * can also be used to match all ports.
     *
     * @return the sourcePortRange value.
     */
    public String sourcePortRange() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRange();
    }

    /**
     * Set the sourcePortRange property: The source port or range. Integer or range between 0 and 65535. Asterisk '*'
     * can also be used to match all ports.
     *
     * @param sourcePortRange the sourcePortRange value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withSourcePortRange(String sourcePortRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourcePortRange(sourcePortRange);
        return this;
    }

    /**
     * Get the destinationPortRange property: The destination port or range. Integer or range between 0 and 65535.
     * Asterisk '*' can also be used to match all ports.
     *
     * @return the destinationPortRange value.
     */
    public String destinationPortRange() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRange();
    }

    /**
     * Set the destinationPortRange property: The destination port or range. Integer or range between 0 and 65535.
     * Asterisk '*' can also be used to match all ports.
     *
     * @param destinationPortRange the destinationPortRange value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDestinationPortRange(String destinationPortRange) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationPortRange(destinationPortRange);
        return this;
    }

    /**
     * Get the sourceAddressPrefix property: The CIDR or source IP range. Asterisk '*' can also be used to match all
     * source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this
     * is an ingress rule, specifies where network traffic originates from.
     *
     * @return the sourceAddressPrefix value.
     */
    public String sourceAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceAddressPrefix();
    }

    /**
     * Set the sourceAddressPrefix property: The CIDR or source IP range. Asterisk '*' can also be used to match all
     * source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and 'Internet' can also be used. If this
     * is an ingress rule, specifies where network traffic originates from.
     *
     * @param sourceAddressPrefix the sourceAddressPrefix value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withSourceAddressPrefix(String sourceAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourceAddressPrefix(sourceAddressPrefix);
        return this;
    }

    /**
     * Get the sourceAddressPrefixes property: The CIDR or source IP ranges.
     *
     * @return the sourceAddressPrefixes value.
     */
    public List<String> sourceAddressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceAddressPrefixes();
    }

    /**
     * Set the sourceAddressPrefixes property: The CIDR or source IP ranges.
     *
     * @param sourceAddressPrefixes the sourceAddressPrefixes value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withSourceAddressPrefixes(List<String> sourceAddressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourceAddressPrefixes(sourceAddressPrefixes);
        return this;
    }

    /**
     * Get the sourceApplicationSecurityGroups property: The application security group specified as source.
     *
     * @return the sourceApplicationSecurityGroups value.
     */
    public List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceApplicationSecurityGroups();
    }

    /**
     * Set the sourceApplicationSecurityGroups property: The application security group specified as source.
     *
     * @param sourceApplicationSecurityGroups the sourceApplicationSecurityGroups value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withSourceApplicationSecurityGroups(
        List<ApplicationSecurityGroupInner> sourceApplicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourceApplicationSecurityGroups(sourceApplicationSecurityGroups);
        return this;
    }

    /**
     * Get the destinationAddressPrefix property: The destination address prefix. CIDR or destination IP range. Asterisk
     * '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and
     * 'Internet' can also be used.
     *
     * @return the destinationAddressPrefix value.
     */
    public String destinationAddressPrefix() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationAddressPrefix();
    }

    /**
     * Set the destinationAddressPrefix property: The destination address prefix. CIDR or destination IP range. Asterisk
     * '*' can also be used to match all source IPs. Default tags such as 'VirtualNetwork', 'AzureLoadBalancer' and
     * 'Internet' can also be used.
     *
     * @param destinationAddressPrefix the destinationAddressPrefix value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDestinationAddressPrefix(String destinationAddressPrefix) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationAddressPrefix(destinationAddressPrefix);
        return this;
    }

    /**
     * Get the destinationAddressPrefixes property: The destination address prefixes. CIDR or destination IP ranges.
     *
     * @return the destinationAddressPrefixes value.
     */
    public List<String> destinationAddressPrefixes() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationAddressPrefixes();
    }

    /**
     * Set the destinationAddressPrefixes property: The destination address prefixes. CIDR or destination IP ranges.
     *
     * @param destinationAddressPrefixes the destinationAddressPrefixes value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDestinationAddressPrefixes(List<String> destinationAddressPrefixes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationAddressPrefixes(destinationAddressPrefixes);
        return this;
    }

    /**
     * Get the destinationApplicationSecurityGroups property: The application security group specified as destination.
     *
     * @return the destinationApplicationSecurityGroups value.
     */
    public List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationApplicationSecurityGroups();
    }

    /**
     * Set the destinationApplicationSecurityGroups property: The application security group specified as destination.
     *
     * @param destinationApplicationSecurityGroups the destinationApplicationSecurityGroups value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDestinationApplicationSecurityGroups(
        List<ApplicationSecurityGroupInner> destinationApplicationSecurityGroups) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationApplicationSecurityGroups(destinationApplicationSecurityGroups);
        return this;
    }

    /**
     * Get the sourcePortRanges property: The source port ranges.
     *
     * @return the sourcePortRanges value.
     */
    public List<String> sourcePortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().sourcePortRanges();
    }

    /**
     * Set the sourcePortRanges property: The source port ranges.
     *
     * @param sourcePortRanges the sourcePortRanges value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withSourcePortRanges(List<String> sourcePortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withSourcePortRanges(sourcePortRanges);
        return this;
    }

    /**
     * Get the destinationPortRanges property: The destination port ranges.
     *
     * @return the destinationPortRanges value.
     */
    public List<String> destinationPortRanges() {
        return this.innerProperties() == null ? null : this.innerProperties().destinationPortRanges();
    }

    /**
     * Set the destinationPortRanges property: The destination port ranges.
     *
     * @param destinationPortRanges the destinationPortRanges value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDestinationPortRanges(List<String> destinationPortRanges) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDestinationPortRanges(destinationPortRanges);
        return this;
    }

    /**
     * Get the access property: The network traffic is allowed or denied.
     *
     * @return the access value.
     */
    public SecurityRuleAccess access() {
        return this.innerProperties() == null ? null : this.innerProperties().access();
    }

    /**
     * Set the access property: The network traffic is allowed or denied.
     *
     * @param access the access value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withAccess(SecurityRuleAccess access) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withAccess(access);
        return this;
    }

    /**
     * Get the priority property: The priority of the rule. The value can be between 100 and 4096. The priority number
     * must be unique for each rule in the collection. The lower the priority number, the higher the priority of the
     * rule.
     *
     * @return the priority value.
     */
    public Integer priority() {
        return this.innerProperties() == null ? null : this.innerProperties().priority();
    }

    /**
     * Set the priority property: The priority of the rule. The value can be between 100 and 4096. The priority number
     * must be unique for each rule in the collection. The lower the priority number, the higher the priority of the
     * rule.
     *
     * @param priority the priority value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withPriority(Integer priority) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withPriority(priority);
        return this;
    }

    /**
     * Get the direction property: The direction of the rule. The direction specifies if rule will be evaluated on
     * incoming or outgoing traffic.
     *
     * @return the direction value.
     */
    public SecurityRuleDirection direction() {
        return this.innerProperties() == null ? null : this.innerProperties().direction();
    }

    /**
     * Set the direction property: The direction of the rule. The direction specifies if rule will be evaluated on
     * incoming or outgoing traffic.
     *
     * @param direction the direction value to set.
     * @return the SecurityRuleInner object itself.
     */
    public SecurityRuleInner withDirection(SecurityRuleDirection direction) {
        if (this.innerProperties() == null) {
            this.innerProperties = new SecurityRulePropertiesFormat();
        }
        this.innerProperties().withDirection(direction);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the security rule resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
