// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Scope Connections resource. */
@Fluent
public final class ScopeConnectionInner extends ChildResource {
    /*
     * The scope connection properties
     */
    @JsonProperty(value = "properties")
    private ScopeConnectionProperties innerProperties;

    /*
     * The system metadata related to this resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: The scope connection properties.
     *
     * @return the innerProperties value.
     */
    private ScopeConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the tenantId property: Tenant ID.
     *
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    /**
     * Set the tenantId property: Tenant ID.
     *
     * @param tenantId the tenantId value to set.
     * @return the ScopeConnectionInner object itself.
     */
    public ScopeConnectionInner withTenantId(String tenantId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopeConnectionProperties();
        }
        this.innerProperties().withTenantId(tenantId);
        return this;
    }

    /**
     * Get the resourceId property: Resource ID.
     *
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.innerProperties() == null ? null : this.innerProperties().resourceId();
    }

    /**
     * Set the resourceId property: Resource ID.
     *
     * @param resourceId the resourceId value to set.
     * @return the ScopeConnectionInner object itself.
     */
    public ScopeConnectionInner withResourceId(String resourceId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopeConnectionProperties();
        }
        this.innerProperties().withResourceId(resourceId);
        return this;
    }

    /**
     * Get the connectionState property: Connection State.
     *
     * @return the connectionState value.
     */
    public ScopeConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    /**
     * Get the description property: A description of the scope connection.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description of the scope connection.
     *
     * @param description the description value to set.
     * @return the ScopeConnectionInner object itself.
     */
    public ScopeConnectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ScopeConnectionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
