// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingPolicy;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The routing intent child resource of a Virtual hub. */
@Fluent
public final class RoutingIntentInner extends SubResource {
    /*
     * Properties of the RoutingIntent resource.
     */
    @JsonProperty(value = "properties")
    private RoutingIntentProperties innerProperties;

    /*
     * The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Resource type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the innerProperties property: Properties of the RoutingIntent resource.
     *
     * @return the innerProperties value.
     */
    private RoutingIntentProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the resource that is unique within a resource group. This name can be used to
     * access the resource.
     *
     * @param name the name value to set.
     * @return the RoutingIntentInner object itself.
     */
    public RoutingIntentInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Resource type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public RoutingIntentInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the routingPolicies property: List of routing policies.
     *
     * @return the routingPolicies value.
     */
    public List<RoutingPolicy> routingPolicies() {
        return this.innerProperties() == null ? null : this.innerProperties().routingPolicies();
    }

    /**
     * Set the routingPolicies property: List of routing policies.
     *
     * @param routingPolicies the routingPolicies value to set.
     * @return the RoutingIntentInner object itself.
     */
    public RoutingIntentInner withRoutingPolicies(List<RoutingPolicy> routingPolicies) {
        if (this.innerProperties() == null) {
            this.innerProperties = new RoutingIntentProperties();
        }
        this.innerProperties().withRoutingPolicies(routingPolicies);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the RoutingIntent resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
