// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RouteNextHopType;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Route resource. */
@Fluent
public final class RoutePropertiesFormat {
    /*
     * The destination CIDR to which the route applies.
     */
    @JsonProperty(value = "addressPrefix")
    private String addressPrefix;

    /*
     * The type of Azure hop the packet should be sent to.
     */
    @JsonProperty(value = "nextHopType", required = true)
    private RouteNextHopType nextHopType;

    /*
     * The IP address packets should be forwarded to. Next hop values are only allowed in routes where the next hop
     * type is VirtualAppliance.
     */
    @JsonProperty(value = "nextHopIpAddress")
    private String nextHopIpAddress;

    /*
     * The provisioning state of the route resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /*
     * A value indicating whether this route overrides overlapping BGP routes regardless of LPM.
     */
    @JsonProperty(value = "hasBgpOverride")
    private Boolean hasBgpOverride;

    /**
     * Get the addressPrefix property: The destination CIDR to which the route applies.
     *
     * @return the addressPrefix value.
     */
    public String addressPrefix() {
        return this.addressPrefix;
    }

    /**
     * Set the addressPrefix property: The destination CIDR to which the route applies.
     *
     * @param addressPrefix the addressPrefix value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withAddressPrefix(String addressPrefix) {
        this.addressPrefix = addressPrefix;
        return this;
    }

    /**
     * Get the nextHopType property: The type of Azure hop the packet should be sent to.
     *
     * @return the nextHopType value.
     */
    public RouteNextHopType nextHopType() {
        return this.nextHopType;
    }

    /**
     * Set the nextHopType property: The type of Azure hop the packet should be sent to.
     *
     * @param nextHopType the nextHopType value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withNextHopType(RouteNextHopType nextHopType) {
        this.nextHopType = nextHopType;
        return this;
    }

    /**
     * Get the nextHopIpAddress property: The IP address packets should be forwarded to. Next hop values are only
     * allowed in routes where the next hop type is VirtualAppliance.
     *
     * @return the nextHopIpAddress value.
     */
    public String nextHopIpAddress() {
        return this.nextHopIpAddress;
    }

    /**
     * Set the nextHopIpAddress property: The IP address packets should be forwarded to. Next hop values are only
     * allowed in routes where the next hop type is VirtualAppliance.
     *
     * @param nextHopIpAddress the nextHopIpAddress value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withNextHopIpAddress(String nextHopIpAddress) {
        this.nextHopIpAddress = nextHopIpAddress;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the route resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the hasBgpOverride property: A value indicating whether this route overrides overlapping BGP routes
     * regardless of LPM.
     *
     * @return the hasBgpOverride value.
     */
    public Boolean hasBgpOverride() {
        return this.hasBgpOverride;
    }

    /**
     * Set the hasBgpOverride property: A value indicating whether this route overrides overlapping BGP routes
     * regardless of LPM.
     *
     * @param hasBgpOverride the hasBgpOverride value to set.
     * @return the RoutePropertiesFormat object itself.
     */
    public RoutePropertiesFormat withHasBgpOverride(Boolean hasBgpOverride) {
        this.hasBgpOverride = hasBgpOverride;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (nextHopType() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property nextHopType in model RoutePropertiesFormat"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RoutePropertiesFormat.class);
}
