// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.PacketCaptureFilter;
import com.azure.resourcemanager.network.models.PacketCaptureMachineScope;
import com.azure.resourcemanager.network.models.PacketCaptureStorageLocation;
import com.azure.resourcemanager.network.models.PacketCaptureTargetType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Parameters that define the create packet capture operation. */
@Fluent
public class PacketCaptureParameters {
    /*
     * The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently supported.
     */
    @JsonProperty(value = "target", required = true)
    private String target;

    /*
     * A list of AzureVMSS instances which can be included or excluded to run packet capture. If both included and
     * excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     */
    @JsonProperty(value = "scope")
    private PacketCaptureMachineScope scope;

    /*
     * Target type of the resource provided.
     */
    @JsonProperty(value = "targetType")
    private PacketCaptureTargetType targetType;

    /*
     * Number of bytes captured per packet, the remaining bytes are truncated.
     */
    @JsonProperty(value = "bytesToCapturePerPacket")
    private Long bytesToCapturePerPacket;

    /*
     * Maximum size of the capture output.
     */
    @JsonProperty(value = "totalBytesPerSession")
    private Long totalBytesPerSession;

    /*
     * Maximum duration of the capture session in seconds.
     */
    @JsonProperty(value = "timeLimitInSeconds")
    private Integer timeLimitInSeconds;

    /*
     * The storage location for a packet capture session.
     */
    @JsonProperty(value = "storageLocation", required = true)
    private PacketCaptureStorageLocation storageLocation;

    /*
     * A list of packet capture filters.
     */
    @JsonProperty(value = "filters")
    private List<PacketCaptureFilter> filters;

    /**
     * Get the target property: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently
     * supported.
     *
     * @return the target value.
     */
    public String target() {
        return this.target;
    }

    /**
     * Set the target property: The ID of the targeted resource, only AzureVM and AzureVMSS as target type are currently
     * supported.
     *
     * @param target the target value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTarget(String target) {
        this.target = target;
        return this;
    }

    /**
     * Get the scope property: A list of AzureVMSS instances which can be included or excluded to run packet capture. If
     * both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     *
     * @return the scope value.
     */
    public PacketCaptureMachineScope scope() {
        return this.scope;
    }

    /**
     * Set the scope property: A list of AzureVMSS instances which can be included or excluded to run packet capture. If
     * both included and excluded are empty, then the packet capture will run on all instances of AzureVMSS.
     *
     * @param scope the scope value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withScope(PacketCaptureMachineScope scope) {
        this.scope = scope;
        return this;
    }

    /**
     * Get the targetType property: Target type of the resource provided.
     *
     * @return the targetType value.
     */
    public PacketCaptureTargetType targetType() {
        return this.targetType;
    }

    /**
     * Set the targetType property: Target type of the resource provided.
     *
     * @param targetType the targetType value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTargetType(PacketCaptureTargetType targetType) {
        this.targetType = targetType;
        return this;
    }

    /**
     * Get the bytesToCapturePerPacket property: Number of bytes captured per packet, the remaining bytes are truncated.
     *
     * @return the bytesToCapturePerPacket value.
     */
    public Long bytesToCapturePerPacket() {
        return this.bytesToCapturePerPacket;
    }

    /**
     * Set the bytesToCapturePerPacket property: Number of bytes captured per packet, the remaining bytes are truncated.
     *
     * @param bytesToCapturePerPacket the bytesToCapturePerPacket value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withBytesToCapturePerPacket(Long bytesToCapturePerPacket) {
        this.bytesToCapturePerPacket = bytesToCapturePerPacket;
        return this;
    }

    /**
     * Get the totalBytesPerSession property: Maximum size of the capture output.
     *
     * @return the totalBytesPerSession value.
     */
    public Long totalBytesPerSession() {
        return this.totalBytesPerSession;
    }

    /**
     * Set the totalBytesPerSession property: Maximum size of the capture output.
     *
     * @param totalBytesPerSession the totalBytesPerSession value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTotalBytesPerSession(Long totalBytesPerSession) {
        this.totalBytesPerSession = totalBytesPerSession;
        return this;
    }

    /**
     * Get the timeLimitInSeconds property: Maximum duration of the capture session in seconds.
     *
     * @return the timeLimitInSeconds value.
     */
    public Integer timeLimitInSeconds() {
        return this.timeLimitInSeconds;
    }

    /**
     * Set the timeLimitInSeconds property: Maximum duration of the capture session in seconds.
     *
     * @param timeLimitInSeconds the timeLimitInSeconds value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withTimeLimitInSeconds(Integer timeLimitInSeconds) {
        this.timeLimitInSeconds = timeLimitInSeconds;
        return this;
    }

    /**
     * Get the storageLocation property: The storage location for a packet capture session.
     *
     * @return the storageLocation value.
     */
    public PacketCaptureStorageLocation storageLocation() {
        return this.storageLocation;
    }

    /**
     * Set the storageLocation property: The storage location for a packet capture session.
     *
     * @param storageLocation the storageLocation value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withStorageLocation(PacketCaptureStorageLocation storageLocation) {
        this.storageLocation = storageLocation;
        return this;
    }

    /**
     * Get the filters property: A list of packet capture filters.
     *
     * @return the filters value.
     */
    public List<PacketCaptureFilter> filters() {
        return this.filters;
    }

    /**
     * Set the filters property: A list of packet capture filters.
     *
     * @param filters the filters value to set.
     * @return the PacketCaptureParameters object itself.
     */
    public PacketCaptureParameters withFilters(List<PacketCaptureFilter> filters) {
        this.filters = filters;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (target() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException("Missing required property target in model PacketCaptureParameters"));
        }
        if (scope() != null) {
            scope().validate();
        }
        if (storageLocation() == null) {
            throw LOGGER
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property storageLocation in model PacketCaptureParameters"));
        } else {
            storageLocation().validate();
        }
        if (filters() != null) {
            filters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(PacketCaptureParameters.class);
}
