// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.OperationPropertiesFormatServiceSpecification;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Description of operation properties format. */
@Fluent
public final class OperationPropertiesFormat {
    /*
     * Specification of the service.
     */
    @JsonProperty(value = "serviceSpecification")
    private OperationPropertiesFormatServiceSpecification serviceSpecification;

    /**
     * Get the serviceSpecification property: Specification of the service.
     *
     * @return the serviceSpecification value.
     */
    public OperationPropertiesFormatServiceSpecification serviceSpecification() {
        return this.serviceSpecification;
    }

    /**
     * Set the serviceSpecification property: Specification of the service.
     *
     * @param serviceSpecification the serviceSpecification value to set.
     * @return the OperationPropertiesFormat object itself.
     */
    public OperationPropertiesFormat withServiceSpecification(
        OperationPropertiesFormatServiceSpecification serviceSpecification) {
        this.serviceSpecification = serviceSpecification;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (serviceSpecification() != null) {
            serviceSpecification().validate();
        }
    }
}
