// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Information about the network manager connection. */
@Fluent
public final class NetworkManagerConnectionProperties {
    /*
     * Network Manager Id.
     */
    @JsonProperty(value = "networkManagerId")
    private String networkManagerId;

    /*
     * Connection state.
     */
    @JsonProperty(value = "connectionState", access = JsonProperty.Access.WRITE_ONLY)
    private ScopeConnectionState connectionState;

    /*
     * A description of the network manager connection.
     */
    @JsonProperty(value = "description")
    private String description;

    /**
     * Get the networkManagerId property: Network Manager Id.
     *
     * @return the networkManagerId value.
     */
    public String networkManagerId() {
        return this.networkManagerId;
    }

    /**
     * Set the networkManagerId property: Network Manager Id.
     *
     * @param networkManagerId the networkManagerId value to set.
     * @return the NetworkManagerConnectionProperties object itself.
     */
    public NetworkManagerConnectionProperties withNetworkManagerId(String networkManagerId) {
        this.networkManagerId = networkManagerId;
        return this;
    }

    /**
     * Get the connectionState property: Connection state.
     *
     * @return the connectionState value.
     */
    public ScopeConnectionState connectionState() {
        return this.connectionState;
    }

    /**
     * Get the description property: A description of the network manager connection.
     *
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: A description of the network manager connection.
     *
     * @param description the description value to set.
     * @return the NetworkManagerConnectionProperties object itself.
     */
    public NetworkManagerConnectionProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
