// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SystemData;
import com.azure.resourcemanager.network.models.ChildResource;
import com.azure.resourcemanager.network.models.ScopeConnectionState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Network Manager Connection resource. */
@Fluent
public final class NetworkManagerConnectionInner extends ChildResource {
    /*
     * The scope connection properties
     */
    @JsonProperty(value = "properties")
    private NetworkManagerConnectionProperties innerProperties;

    /*
     * The system metadata related to this resource.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /**
     * Get the innerProperties property: The scope connection properties.
     *
     * @return the innerProperties value.
     */
    private NetworkManagerConnectionProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: The system metadata related to this resource.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the networkManagerId property: Network Manager Id.
     *
     * @return the networkManagerId value.
     */
    public String networkManagerId() {
        return this.innerProperties() == null ? null : this.innerProperties().networkManagerId();
    }

    /**
     * Set the networkManagerId property: Network Manager Id.
     *
     * @param networkManagerId the networkManagerId value to set.
     * @return the NetworkManagerConnectionInner object itself.
     */
    public NetworkManagerConnectionInner withNetworkManagerId(String networkManagerId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerConnectionProperties();
        }
        this.innerProperties().withNetworkManagerId(networkManagerId);
        return this;
    }

    /**
     * Get the connectionState property: Connection state.
     *
     * @return the connectionState value.
     */
    public ScopeConnectionState connectionState() {
        return this.innerProperties() == null ? null : this.innerProperties().connectionState();
    }

    /**
     * Get the description property: A description of the network manager connection.
     *
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: A description of the network manager connection.
     *
     * @param description the description value to set.
     * @return the NetworkManagerConnectionInner object itself.
     */
    public NetworkManagerConnectionInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new NetworkManagerConnectionProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
