// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Immutable;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The session state detail for a target. */
@Immutable
public final class BastionSessionStateInner {
    /*
     * A unique id for the session.
     */
    @JsonProperty(value = "sessionId", access = JsonProperty.Access.WRITE_ONLY)
    private String sessionId;

    /*
     * Used for extra information.
     */
    @JsonProperty(value = "message", access = JsonProperty.Access.WRITE_ONLY)
    private String message;

    /*
     * The state of the session. Disconnected/Failed/NotFound.
     */
    @JsonProperty(value = "state", access = JsonProperty.Access.WRITE_ONLY)
    private String state;

    /**
     * Get the sessionId property: A unique id for the session.
     *
     * @return the sessionId value.
     */
    public String sessionId() {
        return this.sessionId;
    }

    /**
     * Get the message property: Used for extra information.
     *
     * @return the message value.
     */
    public String message() {
        return this.message;
    }

    /**
     * Get the state property: The state of the session. Disconnected/Failed/NotFound.
     *
     * @return the state value.
     */
    public String state() {
        return this.state;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
