// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.ApplicationGatewayRedirectType;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Redirect configuration of an application gateway. */
@Fluent
public final class ApplicationGatewayRedirectConfigurationInner extends SubResource {
    /*
     * Properties of the application gateway redirect configuration.
     */
    @JsonProperty(value = "properties")
    private ApplicationGatewayRedirectConfigurationPropertiesFormat innerProperties;

    /*
     * Name of the redirect configuration that is unique within an Application Gateway.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Type of the resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the innerProperties property: Properties of the application gateway redirect configuration.
     *
     * @return the innerProperties value.
     */
    private ApplicationGatewayRedirectConfigurationPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the redirect configuration that is unique within an Application Gateway.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the redirect configuration that is unique within an Application Gateway.
     *
     * @param name the name value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public ApplicationGatewayRedirectConfigurationInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the redirectType property: HTTP redirection type.
     *
     * @return the redirectType value.
     */
    public ApplicationGatewayRedirectType redirectType() {
        return this.innerProperties() == null ? null : this.innerProperties().redirectType();
    }

    /**
     * Set the redirectType property: HTTP redirection type.
     *
     * @param redirectType the redirectType value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withRedirectType(ApplicationGatewayRedirectType redirectType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withRedirectType(redirectType);
        return this;
    }

    /**
     * Get the targetListener property: Reference to a listener to redirect the request to.
     *
     * @return the targetListener value.
     */
    public SubResource targetListener() {
        return this.innerProperties() == null ? null : this.innerProperties().targetListener();
    }

    /**
     * Set the targetListener property: Reference to a listener to redirect the request to.
     *
     * @param targetListener the targetListener value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withTargetListener(SubResource targetListener) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withTargetListener(targetListener);
        return this;
    }

    /**
     * Get the targetUrl property: Url to redirect the request to.
     *
     * @return the targetUrl value.
     */
    public String targetUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().targetUrl();
    }

    /**
     * Set the targetUrl property: Url to redirect the request to.
     *
     * @param targetUrl the targetUrl value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withTargetUrl(String targetUrl) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withTargetUrl(targetUrl);
        return this;
    }

    /**
     * Get the includePath property: Include path in the redirected url.
     *
     * @return the includePath value.
     */
    public Boolean includePath() {
        return this.innerProperties() == null ? null : this.innerProperties().includePath();
    }

    /**
     * Set the includePath property: Include path in the redirected url.
     *
     * @param includePath the includePath value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withIncludePath(Boolean includePath) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withIncludePath(includePath);
        return this;
    }

    /**
     * Get the includeQueryString property: Include query string in the redirected url.
     *
     * @return the includeQueryString value.
     */
    public Boolean includeQueryString() {
        return this.innerProperties() == null ? null : this.innerProperties().includeQueryString();
    }

    /**
     * Set the includeQueryString property: Include query string in the redirected url.
     *
     * @param includeQueryString the includeQueryString value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withIncludeQueryString(Boolean includeQueryString) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withIncludeQueryString(includeQueryString);
        return this;
    }

    /**
     * Get the requestRoutingRules property: Request routing specifying redirect configuration.
     *
     * @return the requestRoutingRules value.
     */
    public List<SubResource> requestRoutingRules() {
        return this.innerProperties() == null ? null : this.innerProperties().requestRoutingRules();
    }

    /**
     * Set the requestRoutingRules property: Request routing specifying redirect configuration.
     *
     * @param requestRoutingRules the requestRoutingRules value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withRequestRoutingRules(List<SubResource> requestRoutingRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withRequestRoutingRules(requestRoutingRules);
        return this;
    }

    /**
     * Get the urlPathMaps property: Url path maps specifying default redirect configuration.
     *
     * @return the urlPathMaps value.
     */
    public List<SubResource> urlPathMaps() {
        return this.innerProperties() == null ? null : this.innerProperties().urlPathMaps();
    }

    /**
     * Set the urlPathMaps property: Url path maps specifying default redirect configuration.
     *
     * @param urlPathMaps the urlPathMaps value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withUrlPathMaps(List<SubResource> urlPathMaps) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withUrlPathMaps(urlPathMaps);
        return this;
    }

    /**
     * Get the pathRules property: Path rules specifying redirect configuration.
     *
     * @return the pathRules value.
     */
    public List<SubResource> pathRules() {
        return this.innerProperties() == null ? null : this.innerProperties().pathRules();
    }

    /**
     * Set the pathRules property: Path rules specifying redirect configuration.
     *
     * @param pathRules the pathRules value to set.
     * @return the ApplicationGatewayRedirectConfigurationInner object itself.
     */
    public ApplicationGatewayRedirectConfigurationInner withPathRules(List<SubResource> pathRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayRedirectConfigurationPropertiesFormat();
        }
        this.innerProperties().withPathRules(pathRules);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
