// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.resourcemanager.network.models.IpAllocationMethod;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonProperty;

/** Properties of Frontend IP configuration of an application gateway. */
@Fluent
public final class ApplicationGatewayFrontendIpConfigurationPropertiesFormat {
    /*
     * PrivateIPAddress of the network interface IP Configuration.
     */
    @JsonProperty(value = "privateIPAddress")
    private String privateIpAddress;

    /*
     * The private IP address allocation method.
     */
    @JsonProperty(value = "privateIPAllocationMethod")
    private IpAllocationMethod privateIpAllocationMethod;

    /*
     * Reference to the subnet resource.
     */
    @JsonProperty(value = "subnet")
    private SubResource subnet;

    /*
     * Reference to the PublicIP resource.
     */
    @JsonProperty(value = "publicIPAddress")
    private SubResource publicIpAddress;

    /*
     * Reference to the application gateway private link configuration.
     */
    @JsonProperty(value = "privateLinkConfiguration")
    private SubResource privateLinkConfiguration;

    /*
     * The provisioning state of the frontend IP configuration resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the privateIpAddress property: PrivateIPAddress of the network interface IP Configuration.
     *
     * @return the privateIpAddress value.
     */
    public String privateIpAddress() {
        return this.privateIpAddress;
    }

    /**
     * Set the privateIpAddress property: PrivateIPAddress of the network interface IP Configuration.
     *
     * @param privateIpAddress the privateIpAddress value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
        return this;
    }

    /**
     * Get the privateIpAllocationMethod property: The private IP address allocation method.
     *
     * @return the privateIpAllocationMethod value.
     */
    public IpAllocationMethod privateIpAllocationMethod() {
        return this.privateIpAllocationMethod;
    }

    /**
     * Set the privateIpAllocationMethod property: The private IP address allocation method.
     *
     * @param privateIpAllocationMethod the privateIpAllocationMethod value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateIpAllocationMethod(
        IpAllocationMethod privateIpAllocationMethod) {
        this.privateIpAllocationMethod = privateIpAllocationMethod;
        return this;
    }

    /**
     * Get the subnet property: Reference to the subnet resource.
     *
     * @return the subnet value.
     */
    public SubResource subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: Reference to the subnet resource.
     *
     * @param subnet the subnet value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withSubnet(SubResource subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the publicIpAddress property: Reference to the PublicIP resource.
     *
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.publicIpAddress;
    }

    /**
     * Set the publicIpAddress property: Reference to the PublicIP resource.
     *
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPublicIpAddress(SubResource publicIpAddress) {
        this.publicIpAddress = publicIpAddress;
        return this;
    }

    /**
     * Get the privateLinkConfiguration property: Reference to the application gateway private link configuration.
     *
     * @return the privateLinkConfiguration value.
     */
    public SubResource privateLinkConfiguration() {
        return this.privateLinkConfiguration;
    }

    /**
     * Set the privateLinkConfiguration property: Reference to the application gateway private link configuration.
     *
     * @param privateLinkConfiguration the privateLinkConfiguration value to set.
     * @return the ApplicationGatewayFrontendIpConfigurationPropertiesFormat object itself.
     */
    public ApplicationGatewayFrontendIpConfigurationPropertiesFormat withPrivateLinkConfiguration(
        SubResource privateLinkConfiguration) {
        this.privateLinkConfiguration = privateLinkConfiguration;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the frontend IP configuration resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
