// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.network.fluent.models.AvailableProvidersListInner;
import com.azure.resourcemanager.network.fluent.models.AzureReachabilityReportInner;
import com.azure.resourcemanager.network.fluent.models.ConnectivityInformationInner;
import com.azure.resourcemanager.network.fluent.models.FlowLogInformationInner;
import com.azure.resourcemanager.network.fluent.models.NetworkConfigurationDiagnosticResponseInner;
import com.azure.resourcemanager.network.fluent.models.NetworkWatcherInner;
import com.azure.resourcemanager.network.fluent.models.NextHopResultInner;
import com.azure.resourcemanager.network.fluent.models.SecurityGroupViewResultInner;
import com.azure.resourcemanager.network.fluent.models.TopologyInner;
import com.azure.resourcemanager.network.fluent.models.TroubleshootingResultInner;
import com.azure.resourcemanager.network.fluent.models.VerificationIpFlowResultInner;
import com.azure.resourcemanager.network.models.AvailableProvidersListParameters;
import com.azure.resourcemanager.network.models.AzureReachabilityReportParameters;
import com.azure.resourcemanager.network.models.ConnectivityParameters;
import com.azure.resourcemanager.network.models.FlowLogStatusParameters;
import com.azure.resourcemanager.network.models.NetworkConfigurationDiagnosticParameters;
import com.azure.resourcemanager.network.models.NextHopParameters;
import com.azure.resourcemanager.network.models.QueryTroubleshootingParameters;
import com.azure.resourcemanager.network.models.SecurityGroupViewParameters;
import com.azure.resourcemanager.network.models.TagsObject;
import com.azure.resourcemanager.network.models.TopologyParameters;
import com.azure.resourcemanager.network.models.TroubleshootingParameters;
import com.azure.resourcemanager.network.models.VerificationIpFlowParameters;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in NetworkWatchersClient. */
public interface NetworkWatchersClient
    extends InnerSupportsGet<NetworkWatcherInner>,
        InnerSupportsListing<NetworkWatcherInner>,
        InnerSupportsDelete<Void> {
    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkWatcherInner>> createOrUpdateWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters);

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkWatcherInner> createOrUpdateAsync(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters);

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkWatcherInner createOrUpdate(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters);

    /**
     * Creates or updates a network watcher in the specified resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the network watcher resource.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkWatcherInner> createOrUpdateWithResponse(
        String resourceGroupName, String networkWatcherName, NetworkWatcherInner parameters, Context context);

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkWatcherInner>> getByResourceGroupWithResponseAsync(
        String resourceGroupName, String networkWatcherName);

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkWatcherInner> getByResourceGroupAsync(String resourceGroupName, String networkWatcherName);

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkWatcherInner getByResourceGroup(String resourceGroupName, String networkWatcherName);

    /**
     * Gets the specified network watcher by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the specified network watcher by resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkWatcherInner> getByResourceGroupWithResponse(
        String resourceGroupName, String networkWatcherName, Context context);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String networkWatcherName);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String networkWatcherName);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String networkWatcherName);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<Void>, Void> beginDelete(
        String resourceGroupName, String networkWatcherName, Context context);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Void> deleteAsync(String resourceGroupName, String networkWatcherName);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkWatcherName);

    /**
     * Deletes the specified network watcher resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    void delete(String resourceGroupName, String networkWatcherName, Context context);

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkWatcherInner>> updateTagsWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TagsObject parameters);

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkWatcherInner> updateTagsAsync(
        String resourceGroupName, String networkWatcherName, TagsObject parameters);

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkWatcherInner updateTags(String resourceGroupName, String networkWatcherName, TagsObject parameters);

    /**
     * Updates a network watcher tags.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters supplied to update network watcher tags.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network watcher in a resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkWatcherInner> updateTagsWithResponse(
        String resourceGroupName, String networkWatcherName, TagsObject parameters, Context context);

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkWatcherInner> listByResourceGroupAsync(String resourceGroupName);

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkWatcherInner> listByResourceGroup(String resourceGroupName);

    /**
     * Gets all network watchers by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by resource group as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkWatcherInner> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Gets all network watchers by subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkWatcherInner> listAsync();

    /**
     * Gets all network watchers by subscription.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkWatcherInner> list();

    /**
     * Gets all network watchers by subscription.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return all network watchers by subscription as paginated response with {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkWatcherInner> list(Context context);

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group along with {@link Response} on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<TopologyInner>> getTopologyWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters);

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TopologyInner> getTopologyAsync(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters);

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TopologyInner getTopology(String resourceGroupName, String networkWatcherName, TopologyParameters parameters);

    /**
     * Gets the current network topology by resource group.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the representation of topology.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the current network topology by resource group along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<TopologyInner> getTopologyWithResponse(
        String resourceGroupName, String networkWatcherName, TopologyParameters parameters, Context context);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> verifyIpFlowWithResponseAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlowAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<VerificationIpFlowResultInner>, VerificationIpFlowResultInner> beginVerifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<VerificationIpFlowResultInner> verifyIpFlowAsync(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VerificationIpFlowResultInner verifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters);

    /**
     * Verify IP flow from the specified VM to a location given the currently configured NSG rules.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the IP flow to be verified.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return results of IP flow verification on the target resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    VerificationIpFlowResultInner verifyIpFlow(
        String resourceGroupName, String networkWatcherName, VerificationIpFlowParameters parameters, Context context);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getNextHopWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHopAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NextHopResultInner>, NextHopResultInner> beginGetNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NextHopResultInner> getNextHopAsync(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NextHopResultInner getNextHop(String resourceGroupName, String networkWatcherName, NextHopParameters parameters);

    /**
     * Gets the next hop from the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the source and destination endpoint.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the next hop from the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NextHopResultInner getNextHop(
        String resourceGroupName, String networkWatcherName, NextHopParameters parameters, Context context);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getVMSecurityRulesWithResponseAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner> beginGetVMSecurityRulesAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner> beginGetVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the configured and effective security group rules on the specified
     *     VM.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<SecurityGroupViewResultInner>, SecurityGroupViewResultInner> beginGetVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters, Context context);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SecurityGroupViewResultInner> getVMSecurityRulesAsync(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SecurityGroupViewResultInner getVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters);

    /**
     * Gets the configured and effective security group rules on the specified VM.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters that define the VM to check security groups for.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the configured and effective security group rules on the specified VM.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SecurityGroupViewResultInner getVMSecurityRules(
        String resourceGroupName, String networkWatcherName, SecurityGroupViewParameters parameters, Context context);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource along with {@link Response} on successful
     *     completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getTroubleshootingWithResponseAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TroubleshootingResultInner> getTroubleshootingAsync(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TroubleshootingResultInner getTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters);

    /**
     * Initiate troubleshooting on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to troubleshoot.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return troubleshooting information gained from specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TroubleshootingResultInner getTroubleshooting(
        String resourceGroupName, String networkWatcherName, TroubleshootingParameters parameters, Context context);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getTroubleshootingResultWithResponseAsync(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingResultAsync(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingResult(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<TroubleshootingResultInner>, TroubleshootingResultInner> beginGetTroubleshootingResult(
        String resourceGroupName,
        String networkWatcherName,
        QueryTroubleshootingParameters parameters,
        Context context);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<TroubleshootingResultInner> getTroubleshootingResultAsync(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TroubleshootingResultInner getTroubleshootingResult(
        String resourceGroupName, String networkWatcherName, QueryTroubleshootingParameters parameters);

    /**
     * Get the last completed troubleshooting result on a specified resource.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the resource to query the troubleshooting result.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the last completed troubleshooting result on a specified resource.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    TroubleshootingResultInner getTroubleshootingResult(
        String resourceGroupName,
        String networkWatcherName,
        QueryTroubleshootingParameters parameters,
        Context context);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> setFlowLogConfigurationWithResponseAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfigurationAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginSetFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FlowLogInformationInner> setFlowLogConfigurationAsync(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FlowLogInformationInner setFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters);

    /**
     * Configures flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define the configuration of flow log.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FlowLogInformationInner setFlowLogConfiguration(
        String resourceGroupName, String networkWatcherName, FlowLogInformationInner parameters, Context context);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) along with {@link Response}
     *     on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getFlowLogStatusWithResponseAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatusAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the configuration of flow log and traffic analytics
     *     (optional).
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<FlowLogInformationInner>, FlowLogInformationInner> beginGetFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional) on successful completion of
     *     {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<FlowLogInformationInner> getFlowLogStatusAsync(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FlowLogInformationInner getFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters);

    /**
     * Queries status of flow log and traffic analytics (optional) on a specified resource.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that define a resource to query flow log and traffic analytics (optional) status.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the configuration of flow log and traffic analytics (optional).
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    FlowLogInformationInner getFlowLogStatus(
        String resourceGroupName, String networkWatcherName, FlowLogStatusParameters parameters, Context context);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> checkConnectivityWithResponseAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner> beginCheckConnectivityAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner> beginCheckConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<ConnectivityInformationInner>, ConnectivityInformationInner> beginCheckConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<ConnectivityInformationInner> checkConnectivityAsync(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectivityInformationInner checkConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters);

    /**
     * Verifies the possibility of establishing a direct TCP connection from a virtual machine to a given endpoint
     * including another VM or an arbitrary remote server.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine how the connectivity check will be performed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return information on the connectivity status.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    ConnectivityInformationInner checkConnectivity(
        String resourceGroupName, String networkWatcherName, ConnectivityParameters parameters, Context context);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details along with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getAzureReachabilityReportWithResponseAsync(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner>
        beginGetAzureReachabilityReportAsync(
            String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner> beginGetAzureReachabilityReport(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AzureReachabilityReportInner>, AzureReachabilityReportInner> beginGetAzureReachabilityReport(
        String resourceGroupName,
        String networkWatcherName,
        AzureReachabilityReportParameters parameters,
        Context context);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AzureReachabilityReportInner> getAzureReachabilityReportAsync(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AzureReachabilityReportInner getAzureReachabilityReport(
        String resourceGroupName, String networkWatcherName, AzureReachabilityReportParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Gets the relative latency score
     * for internet service providers from a specified location to Azure regions.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that determine Azure reachability report configuration.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return azure reachability report details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AzureReachabilityReportInner getAzureReachabilityReport(
        String resourceGroupName,
        String networkWatcherName,
        AzureReachabilityReportParameters parameters,
        Context context);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> listAvailableProvidersWithResponseAsync(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner> beginListAvailableProvidersAsync(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner> beginListAvailableProviders(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<AvailableProvidersListInner>, AvailableProvidersListInner> beginListAvailableProviders(
        String resourceGroupName,
        String networkWatcherName,
        AvailableProvidersListParameters parameters,
        Context context);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<AvailableProvidersListInner> listAvailableProvidersAsync(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AvailableProvidersListInner listAvailableProviders(
        String resourceGroupName, String networkWatcherName, AvailableProvidersListParameters parameters);

    /**
     * NOTE: This feature is currently in preview and still being tested for stability. Lists all available internet
     * service providers for a specified Azure region.
     *
     * @param resourceGroupName The name of the network watcher resource group.
     * @param networkWatcherName The name of the network watcher resource.
     * @param parameters Parameters that scope the list of available providers.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return list of available countries with details.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    AvailableProvidersListInner listAvailableProviders(
        String resourceGroupName,
        String networkWatcherName,
        AvailableProvidersListParameters parameters,
        Context context);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior along with
     *     {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<Flux<ByteBuffer>>> getNetworkConfigurationDiagnosticWithResponseAsync(
        String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    PollerFlux<PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnosticAsync(
            String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnostic(
            String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of network Configuration Diagnostic data to help customers understand
     *     and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    SyncPoller<PollResult<NetworkConfigurationDiagnosticResponseInner>, NetworkConfigurationDiagnosticResponseInner>
        beginGetNetworkConfigurationDiagnostic(
            String resourceGroupName,
            String networkWatcherName,
            NetworkConfigurationDiagnosticParameters parameters,
            Context context);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkConfigurationDiagnosticResponseInner> getNetworkConfigurationDiagnosticAsync(
        String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkConfigurationDiagnosticResponseInner getNetworkConfigurationDiagnostic(
        String resourceGroupName, String networkWatcherName, NetworkConfigurationDiagnosticParameters parameters);

    /**
     * Gets Network Configuration Diagnostic data to help customers understand and debug network behavior. It provides
     * detailed information on what security rules were applied to a specified traffic flow and the result of evaluating
     * these rules. Customers must provide details of a flow like source, destination, protocol, etc. The API returns
     * whether traffic was allowed or denied, the rules evaluated for the specified flow and the evaluation results.
     *
     * @param resourceGroupName The name of the resource group.
     * @param networkWatcherName The name of the network watcher.
     * @param parameters Parameters to get network configuration diagnostic.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return network Configuration Diagnostic data to help customers understand and debug network behavior.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkConfigurationDiagnosticResponseInner getNetworkConfigurationDiagnostic(
        String resourceGroupName,
        String networkWatcherName,
        NetworkConfigurationDiagnosticParameters parameters,
        Context context);
}
