/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.SecurityRuleInner;
import com.azure.resourcemanager.network.models.EffectiveNetworkSecurityRule;
import com.azure.resourcemanager.network.models.NetworkInterfaceAssociation;
import com.azure.resourcemanager.network.models.SubnetAssociation;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class SecurityRuleAssociations {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(SecurityRuleAssociations.class);
    @JsonProperty(value="networkInterfaceAssociation")
    private NetworkInterfaceAssociation networkInterfaceAssociation;
    @JsonProperty(value="subnetAssociation")
    private SubnetAssociation subnetAssociation;
    @JsonProperty(value="defaultSecurityRules")
    private List<SecurityRuleInner> defaultSecurityRules;
    @JsonProperty(value="effectiveSecurityRules")
    private List<EffectiveNetworkSecurityRule> effectiveSecurityRules;

    public NetworkInterfaceAssociation networkInterfaceAssociation() {
        return this.networkInterfaceAssociation;
    }

    public SecurityRuleAssociations withNetworkInterfaceAssociation(NetworkInterfaceAssociation networkInterfaceAssociation) {
        this.networkInterfaceAssociation = networkInterfaceAssociation;
        return this;
    }

    public SubnetAssociation subnetAssociation() {
        return this.subnetAssociation;
    }

    public SecurityRuleAssociations withSubnetAssociation(SubnetAssociation subnetAssociation) {
        this.subnetAssociation = subnetAssociation;
        return this;
    }

    public List<SecurityRuleInner> defaultSecurityRules() {
        return this.defaultSecurityRules;
    }

    public SecurityRuleAssociations withDefaultSecurityRules(List<SecurityRuleInner> defaultSecurityRules) {
        this.defaultSecurityRules = defaultSecurityRules;
        return this;
    }

    public List<EffectiveNetworkSecurityRule> effectiveSecurityRules() {
        return this.effectiveSecurityRules;
    }

    public SecurityRuleAssociations withEffectiveSecurityRules(List<EffectiveNetworkSecurityRule> effectiveSecurityRules) {
        this.effectiveSecurityRules = effectiveSecurityRules;
        return this;
    }

    public void validate() {
        if (this.networkInterfaceAssociation() != null) {
            this.networkInterfaceAssociation().validate();
        }
        if (this.subnetAssociation() != null) {
            this.subnetAssociation().validate();
        }
        if (this.defaultSecurityRules() != null) {
            this.defaultSecurityRules().forEach(e -> e.validate());
        }
        if (this.effectiveSecurityRules() != null) {
            this.effectiveSecurityRules().forEach(e -> e.validate());
        }
    }
}

