/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.InboundNatPoolPropertiesFormat;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.TransportProtocol;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class InboundNatPool
extends SubResource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(InboundNatPool.class);
    @JsonProperty(value="properties")
    private InboundNatPoolPropertiesFormat innerProperties;
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="etag", access=JsonProperty.Access.WRITE_ONLY)
    private String etag;
    @JsonProperty(value="type", access=JsonProperty.Access.WRITE_ONLY)
    private String type;

    private InboundNatPoolPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    public String name() {
        return this.name;
    }

    public InboundNatPool withName(String name) {
        this.name = name;
        return this;
    }

    public String etag() {
        return this.etag;
    }

    public String type() {
        return this.type;
    }

    public InboundNatPool withId(String id) {
        super.withId(id);
        return this;
    }

    public SubResource frontendIpConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().frontendIpConfiguration();
    }

    public InboundNatPool withFrontendIpConfiguration(SubResource frontendIpConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withFrontendIpConfiguration(frontendIpConfiguration);
        return this;
    }

    public TransportProtocol protocol() {
        return this.innerProperties() == null ? null : this.innerProperties().protocol();
    }

    public InboundNatPool withProtocol(TransportProtocol protocol) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withProtocol(protocol);
        return this;
    }

    public Integer frontendPortRangeStart() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().frontendPortRangeStart());
    }

    public InboundNatPool withFrontendPortRangeStart(Integer frontendPortRangeStart) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withFrontendPortRangeStart(frontendPortRangeStart);
        return this;
    }

    public Integer frontendPortRangeEnd() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().frontendPortRangeEnd());
    }

    public InboundNatPool withFrontendPortRangeEnd(Integer frontendPortRangeEnd) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withFrontendPortRangeEnd(frontendPortRangeEnd);
        return this;
    }

    public Integer backendPort() {
        return this.innerProperties() == null ? null : Integer.valueOf(this.innerProperties().backendPort());
    }

    public InboundNatPool withBackendPort(Integer backendPort) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withBackendPort(backendPort);
        return this;
    }

    public Integer idleTimeoutInMinutes() {
        return this.innerProperties() == null ? null : this.innerProperties().idleTimeoutInMinutes();
    }

    public InboundNatPool withIdleTimeoutInMinutes(Integer idleTimeoutInMinutes) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withIdleTimeoutInMinutes(idleTimeoutInMinutes);
        return this;
    }

    public Boolean enableFloatingIp() {
        return this.innerProperties() == null ? null : this.innerProperties().enableFloatingIp();
    }

    public InboundNatPool withEnableFloatingIp(Boolean enableFloatingIp) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withEnableFloatingIp(enableFloatingIp);
        return this;
    }

    public Boolean enableTcpReset() {
        return this.innerProperties() == null ? null : this.innerProperties().enableTcpReset();
    }

    public InboundNatPool withEnableTcpReset(Boolean enableTcpReset) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundNatPoolPropertiesFormat();
        }
        this.innerProperties().withEnableTcpReset(enableTcpReset);
        return this;
    }

    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }
}

