/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.BackendAddressPoolInner;
import com.azure.resourcemanager.network.fluent.models.FrontendIpConfigurationInner;
import com.azure.resourcemanager.network.fluent.models.InboundNatRuleInner;
import com.azure.resourcemanager.network.fluent.models.LoadBalancingRuleInner;
import com.azure.resourcemanager.network.fluent.models.OutboundRuleInner;
import com.azure.resourcemanager.network.fluent.models.ProbeInner;
import com.azure.resourcemanager.network.models.InboundNatPool;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class LoadBalancerPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LoadBalancerPropertiesFormat.class);
    @JsonProperty(value="frontendIPConfigurations")
    private List<FrontendIpConfigurationInner> frontendIpConfigurations;
    @JsonProperty(value="backendAddressPools")
    private List<BackendAddressPoolInner> backendAddressPools;
    @JsonProperty(value="loadBalancingRules")
    private List<LoadBalancingRuleInner> loadBalancingRules;
    @JsonProperty(value="probes")
    private List<ProbeInner> probes;
    @JsonProperty(value="inboundNatRules")
    private List<InboundNatRuleInner> inboundNatRules;
    @JsonProperty(value="inboundNatPools")
    private List<InboundNatPool> inboundNatPools;
    @JsonProperty(value="outboundRules")
    private List<OutboundRuleInner> outboundRules;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public List<FrontendIpConfigurationInner> frontendIpConfigurations() {
        return this.frontendIpConfigurations;
    }

    public LoadBalancerPropertiesFormat withFrontendIpConfigurations(List<FrontendIpConfigurationInner> frontendIpConfigurations) {
        this.frontendIpConfigurations = frontendIpConfigurations;
        return this;
    }

    public List<BackendAddressPoolInner> backendAddressPools() {
        return this.backendAddressPools;
    }

    public LoadBalancerPropertiesFormat withBackendAddressPools(List<BackendAddressPoolInner> backendAddressPools) {
        this.backendAddressPools = backendAddressPools;
        return this;
    }

    public List<LoadBalancingRuleInner> loadBalancingRules() {
        return this.loadBalancingRules;
    }

    public LoadBalancerPropertiesFormat withLoadBalancingRules(List<LoadBalancingRuleInner> loadBalancingRules) {
        this.loadBalancingRules = loadBalancingRules;
        return this;
    }

    public List<ProbeInner> probes() {
        return this.probes;
    }

    public LoadBalancerPropertiesFormat withProbes(List<ProbeInner> probes) {
        this.probes = probes;
        return this;
    }

    public List<InboundNatRuleInner> inboundNatRules() {
        return this.inboundNatRules;
    }

    public LoadBalancerPropertiesFormat withInboundNatRules(List<InboundNatRuleInner> inboundNatRules) {
        this.inboundNatRules = inboundNatRules;
        return this;
    }

    public List<InboundNatPool> inboundNatPools() {
        return this.inboundNatPools;
    }

    public LoadBalancerPropertiesFormat withInboundNatPools(List<InboundNatPool> inboundNatPools) {
        this.inboundNatPools = inboundNatPools;
        return this;
    }

    public List<OutboundRuleInner> outboundRules() {
        return this.outboundRules;
    }

    public LoadBalancerPropertiesFormat withOutboundRules(List<OutboundRuleInner> outboundRules) {
        this.outboundRules = outboundRules;
        return this;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.frontendIpConfigurations() != null) {
            this.frontendIpConfigurations().forEach(e -> e.validate());
        }
        if (this.backendAddressPools() != null) {
            this.backendAddressPools().forEach(e -> e.validate());
        }
        if (this.loadBalancingRules() != null) {
            this.loadBalancingRules().forEach(e -> e.validate());
        }
        if (this.probes() != null) {
            this.probes().forEach(e -> e.validate());
        }
        if (this.inboundNatRules() != null) {
            this.inboundNatRules().forEach(e -> e.validate());
        }
        if (this.inboundNatPools() != null) {
            this.inboundNatPools().forEach(e -> e.validate());
        }
        if (this.outboundRules() != null) {
            this.outboundRules().forEach(e -> e.validate());
        }
    }
}

