/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.NetworkInterfaceInner;
import com.azure.resourcemanager.network.models.ProtocolType;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.QosDefinition;
import com.azure.resourcemanager.network.models.QosIpRange;
import com.azure.resourcemanager.network.models.QosPortRange;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class DscpConfigurationPropertiesFormat {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(DscpConfigurationPropertiesFormat.class);
    @JsonProperty(value="markings")
    private List<Integer> markings;
    @JsonProperty(value="sourceIpRanges")
    private List<QosIpRange> sourceIpRanges;
    @JsonProperty(value="destinationIpRanges")
    private List<QosIpRange> destinationIpRanges;
    @JsonProperty(value="sourcePortRanges")
    private List<QosPortRange> sourcePortRanges;
    @JsonProperty(value="destinationPortRanges")
    private List<QosPortRange> destinationPortRanges;
    @JsonProperty(value="protocol")
    private ProtocolType protocol;
    @JsonProperty(value="qosDefinitionCollection")
    private List<QosDefinition> qosDefinitionCollection;
    @JsonProperty(value="qosCollectionId", access=JsonProperty.Access.WRITE_ONLY)
    private String qosCollectionId;
    @JsonProperty(value="associatedNetworkInterfaces", access=JsonProperty.Access.WRITE_ONLY)
    private List<NetworkInterfaceInner> associatedNetworkInterfaces;
    @JsonProperty(value="resourceGuid", access=JsonProperty.Access.WRITE_ONLY)
    private String resourceGuid;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    public List<Integer> markings() {
        return this.markings;
    }

    public DscpConfigurationPropertiesFormat withMarkings(List<Integer> markings) {
        this.markings = markings;
        return this;
    }

    public List<QosIpRange> sourceIpRanges() {
        return this.sourceIpRanges;
    }

    public DscpConfigurationPropertiesFormat withSourceIpRanges(List<QosIpRange> sourceIpRanges) {
        this.sourceIpRanges = sourceIpRanges;
        return this;
    }

    public List<QosIpRange> destinationIpRanges() {
        return this.destinationIpRanges;
    }

    public DscpConfigurationPropertiesFormat withDestinationIpRanges(List<QosIpRange> destinationIpRanges) {
        this.destinationIpRanges = destinationIpRanges;
        return this;
    }

    public List<QosPortRange> sourcePortRanges() {
        return this.sourcePortRanges;
    }

    public DscpConfigurationPropertiesFormat withSourcePortRanges(List<QosPortRange> sourcePortRanges) {
        this.sourcePortRanges = sourcePortRanges;
        return this;
    }

    public List<QosPortRange> destinationPortRanges() {
        return this.destinationPortRanges;
    }

    public DscpConfigurationPropertiesFormat withDestinationPortRanges(List<QosPortRange> destinationPortRanges) {
        this.destinationPortRanges = destinationPortRanges;
        return this;
    }

    public ProtocolType protocol() {
        return this.protocol;
    }

    public DscpConfigurationPropertiesFormat withProtocol(ProtocolType protocol) {
        this.protocol = protocol;
        return this;
    }

    public List<QosDefinition> qosDefinitionCollection() {
        return this.qosDefinitionCollection;
    }

    public DscpConfigurationPropertiesFormat withQosDefinitionCollection(List<QosDefinition> qosDefinitionCollection) {
        this.qosDefinitionCollection = qosDefinitionCollection;
        return this;
    }

    public String qosCollectionId() {
        return this.qosCollectionId;
    }

    public List<NetworkInterfaceInner> associatedNetworkInterfaces() {
        return this.associatedNetworkInterfaces;
    }

    public String resourceGuid() {
        return this.resourceGuid;
    }

    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public void validate() {
        if (this.sourceIpRanges() != null) {
            this.sourceIpRanges().forEach(e -> e.validate());
        }
        if (this.destinationIpRanges() != null) {
            this.destinationIpRanges().forEach(e -> e.validate());
        }
        if (this.sourcePortRanges() != null) {
            this.sourcePortRanges().forEach(e -> e.validate());
        }
        if (this.destinationPortRanges() != null) {
            this.destinationPortRanges().forEach(e -> e.validate());
        }
        if (this.qosDefinitionCollection() != null) {
            this.qosDefinitionCollection().forEach(e -> e.validate());
        }
        if (this.associatedNetworkInterfaces() != null) {
            this.associatedNetworkInterfaces().forEach(e -> e.validate());
        }
    }
}

