// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The sku of this Bastion Host. */
@Fluent
public final class Sku {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(Sku.class);

    /*
     * The name of this Bastion Host.
     */
    @JsonProperty(value = "name")
    private BastionHostSkuName name;

    /**
     * Get the name property: The name of this Bastion Host.
     *
     * @return the name value.
     */
    public BastionHostSkuName name() {
        return this.name;
    }

    /**
     * Set the name property: The name of this Bastion Host.
     *
     * @param name the name value to set.
     * @return the Sku object itself.
     */
    public Sku withName(BastionHostSkuName name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
