// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for SingleQueryResultMode. */
public final class SingleQueryResultMode extends ExpandableStringEnum<SingleQueryResultMode> {
    /** Static value 0 for SingleQueryResultMode. */
    public static final SingleQueryResultMode ZERO = fromInt(0);

    /** Static value 1 for SingleQueryResultMode. */
    public static final SingleQueryResultMode ONE = fromInt(1);

    /** Static value 2 for SingleQueryResultMode. */
    public static final SingleQueryResultMode TWO = fromInt(2);

    /**
     * Creates or finds a SingleQueryResultMode from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding SingleQueryResultMode.
     */
    @JsonCreator
    public static SingleQueryResultMode fromInt(int name) {
        return fromString(String.valueOf(name), SingleQueryResultMode.class);
    }

    /** @return known SingleQueryResultMode values. */
    public static Collection<SingleQueryResultMode> values() {
        return values(SingleQueryResultMode.class);
    }
}
