// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.LoadBalancerVipSwapRequestFrontendIpConfigurationProperties;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** VIP swap request's frontend IP configuration object. */
@Fluent
public final class LoadBalancerVipSwapRequestFrontendIpConfiguration {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(LoadBalancerVipSwapRequestFrontendIpConfiguration.class);

    /*
     * The ID of frontend IP configuration resource.
     */
    @JsonProperty(value = "id")
    private String id;

    /*
     * The properties of VIP swap request's frontend IP configuration object.
     */
    @JsonProperty(value = "properties")
    private LoadBalancerVipSwapRequestFrontendIpConfigurationProperties innerProperties;

    /**
     * Get the id property: The ID of frontend IP configuration resource.
     *
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The ID of frontend IP configuration resource.
     *
     * @param id the id value to set.
     * @return the LoadBalancerVipSwapRequestFrontendIpConfiguration object itself.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the innerProperties property: The properties of VIP swap request's frontend IP configuration object.
     *
     * @return the innerProperties value.
     */
    private LoadBalancerVipSwapRequestFrontendIpConfigurationProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the publicIpAddress property: A reference to public IP address resource.
     *
     * @return the publicIpAddress value.
     */
    public SubResource publicIpAddress() {
        return this.innerProperties() == null ? null : this.innerProperties().publicIpAddress();
    }

    /**
     * Set the publicIpAddress property: A reference to public IP address resource.
     *
     * @param publicIpAddress the publicIpAddress value to set.
     * @return the LoadBalancerVipSwapRequestFrontendIpConfiguration object itself.
     */
    public LoadBalancerVipSwapRequestFrontendIpConfiguration withPublicIpAddress(SubResource publicIpAddress) {
        if (this.innerProperties() == null) {
            this.innerProperties = new LoadBalancerVipSwapRequestFrontendIpConfigurationProperties();
        }
        this.innerProperties().withPublicIpAddress(publicIpAddress);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
