// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for ExpressRouteLinkMacSecCipher. */
public final class ExpressRouteLinkMacSecCipher extends ExpandableStringEnum<ExpressRouteLinkMacSecCipher> {
    /** Static value GcmAes256 for ExpressRouteLinkMacSecCipher. */
    public static final ExpressRouteLinkMacSecCipher GCM_AES256 = fromString("GcmAes256");

    /** Static value GcmAes128 for ExpressRouteLinkMacSecCipher. */
    public static final ExpressRouteLinkMacSecCipher GCM_AES128 = fromString("GcmAes128");

    /** Static value GcmAesXpn128 for ExpressRouteLinkMacSecCipher. */
    public static final ExpressRouteLinkMacSecCipher GCM_AES_XPN128 = fromString("GcmAesXpn128");

    /** Static value GcmAesXpn256 for ExpressRouteLinkMacSecCipher. */
    public static final ExpressRouteLinkMacSecCipher GCM_AES_XPN256 = fromString("GcmAesXpn256");

    /**
     * Creates or finds a ExpressRouteLinkMacSecCipher from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding ExpressRouteLinkMacSecCipher.
     */
    @JsonCreator
    public static ExpressRouteLinkMacSecCipher fromString(String name) {
        return fromString(name, ExpressRouteLinkMacSecCipher.class);
    }

    /** @return known ExpressRouteLinkMacSecCipher values. */
    public static Collection<ExpressRouteLinkMacSecCipher> values() {
        return values(ExpressRouteLinkMacSecCipher.class);
    }
}
