// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.ExpressRouteCircuitConnectionInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Response for ListConnections API service call retrieves all global reach connections that belongs to a Private
 * Peering for an ExpressRouteCircuit.
 */
@Fluent
public final class ExpressRouteCircuitConnectionListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ExpressRouteCircuitConnectionListResult.class);

    /*
     * The global reach connection associated with Private Peering in an
     * ExpressRoute Circuit.
     */
    @JsonProperty(value = "value")
    private List<ExpressRouteCircuitConnectionInner> value;

    /*
     * The URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The global reach connection associated with Private Peering in an ExpressRoute Circuit.
     *
     * @return the value value.
     */
    public List<ExpressRouteCircuitConnectionInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The global reach connection associated with Private Peering in an ExpressRoute Circuit.
     *
     * @param value the value value to set.
     * @return the ExpressRouteCircuitConnectionListResult object itself.
     */
    public ExpressRouteCircuitConnectionListResult withValue(List<ExpressRouteCircuitConnectionInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the ExpressRouteCircuitConnectionListResult object itself.
     */
    public ExpressRouteCircuitConnectionListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
