// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The ARP table associated with the ExpressRouteCircuit. */
@Fluent
public final class ExpressRouteCircuitArpTable {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ExpressRouteCircuitArpTable.class);

    /*
     * Entry age in minutes.
     */
    @JsonProperty(value = "age")
    private Integer age;

    /*
     * Interface address.
     */
    @JsonProperty(value = "interface")
    private String interfaceProperty;

    /*
     * The IP address.
     */
    @JsonProperty(value = "ipAddress")
    private String ipAddress;

    /*
     * The MAC address.
     */
    @JsonProperty(value = "macAddress")
    private String macAddress;

    /**
     * Get the age property: Entry age in minutes.
     *
     * @return the age value.
     */
    public Integer age() {
        return this.age;
    }

    /**
     * Set the age property: Entry age in minutes.
     *
     * @param age the age value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withAge(Integer age) {
        this.age = age;
        return this;
    }

    /**
     * Get the interfaceProperty property: Interface address.
     *
     * @return the interfaceProperty value.
     */
    public String interfaceProperty() {
        return this.interfaceProperty;
    }

    /**
     * Set the interfaceProperty property: Interface address.
     *
     * @param interfaceProperty the interfaceProperty value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withInterfaceProperty(String interfaceProperty) {
        this.interfaceProperty = interfaceProperty;
        return this;
    }

    /**
     * Get the ipAddress property: The IP address.
     *
     * @return the ipAddress value.
     */
    public String ipAddress() {
        return this.ipAddress;
    }

    /**
     * Set the ipAddress property: The IP address.
     *
     * @param ipAddress the ipAddress value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        return this;
    }

    /**
     * Get the macAddress property: The MAC address.
     *
     * @return the macAddress value.
     */
    public String macAddress() {
        return this.macAddress;
    }

    /**
     * Set the macAddress property: The MAC address.
     *
     * @param macAddress the macAddress value to set.
     * @return the ExpressRouteCircuitArpTable object itself.
     */
    public ExpressRouteCircuitArpTable withMacAddress(String macAddress) {
        this.macAddress = macAddress;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
