// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Defines a managed rule set for Exclusions. */
@Fluent
public final class ExclusionManagedRuleSet {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ExclusionManagedRuleSet.class);

    /*
     * Defines the rule set type to use.
     */
    @JsonProperty(value = "ruleSetType", required = true)
    private String ruleSetType;

    /*
     * Defines the version of the rule set to use.
     */
    @JsonProperty(value = "ruleSetVersion", required = true)
    private String ruleSetVersion;

    /*
     * Defines the rule groups to apply to the rule set.
     */
    @JsonProperty(value = "ruleGroups")
    private List<ExclusionManagedRuleGroup> ruleGroups;

    /**
     * Get the ruleSetType property: Defines the rule set type to use.
     *
     * @return the ruleSetType value.
     */
    public String ruleSetType() {
        return this.ruleSetType;
    }

    /**
     * Set the ruleSetType property: Defines the rule set type to use.
     *
     * @param ruleSetType the ruleSetType value to set.
     * @return the ExclusionManagedRuleSet object itself.
     */
    public ExclusionManagedRuleSet withRuleSetType(String ruleSetType) {
        this.ruleSetType = ruleSetType;
        return this;
    }

    /**
     * Get the ruleSetVersion property: Defines the version of the rule set to use.
     *
     * @return the ruleSetVersion value.
     */
    public String ruleSetVersion() {
        return this.ruleSetVersion;
    }

    /**
     * Set the ruleSetVersion property: Defines the version of the rule set to use.
     *
     * @param ruleSetVersion the ruleSetVersion value to set.
     * @return the ExclusionManagedRuleSet object itself.
     */
    public ExclusionManagedRuleSet withRuleSetVersion(String ruleSetVersion) {
        this.ruleSetVersion = ruleSetVersion;
        return this;
    }

    /**
     * Get the ruleGroups property: Defines the rule groups to apply to the rule set.
     *
     * @return the ruleGroups value.
     */
    public List<ExclusionManagedRuleGroup> ruleGroups() {
        return this.ruleGroups;
    }

    /**
     * Set the ruleGroups property: Defines the rule groups to apply to the rule set.
     *
     * @param ruleGroups the ruleGroups value to set.
     * @return the ExclusionManagedRuleSet object itself.
     */
    public ExclusionManagedRuleSet withRuleGroups(List<ExclusionManagedRuleGroup> ruleGroups) {
        this.ruleGroups = ruleGroups;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (ruleSetType() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property ruleSetType in model ExclusionManagedRuleSet"));
        }
        if (ruleSetVersion() == null) {
            throw logger
                .logExceptionAsError(
                    new IllegalArgumentException(
                        "Missing required property ruleSetVersion in model ExclusionManagedRuleSet"));
        }
        if (ruleGroups() != null) {
            ruleGroups().forEach(e -> e.validate());
        }
    }
}
