// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** DNS Proxy Settings in Firewall Policy. */
@Fluent
public final class DnsSettings {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(DnsSettings.class);

    /*
     * List of Custom DNS Servers.
     */
    @JsonProperty(value = "servers")
    private List<String> servers;

    /*
     * Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     */
    @JsonProperty(value = "enableProxy")
    private Boolean enableProxy;

    /*
     * FQDNs in Network Rules are supported when set to true.
     */
    @JsonProperty(value = "requireProxyForNetworkRules")
    private Boolean requireProxyForNetworkRules;

    /**
     * Get the servers property: List of Custom DNS Servers.
     *
     * @return the servers value.
     */
    public List<String> servers() {
        return this.servers;
    }

    /**
     * Set the servers property: List of Custom DNS Servers.
     *
     * @param servers the servers value to set.
     * @return the DnsSettings object itself.
     */
    public DnsSettings withServers(List<String> servers) {
        this.servers = servers;
        return this;
    }

    /**
     * Get the enableProxy property: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     *
     * @return the enableProxy value.
     */
    public Boolean enableProxy() {
        return this.enableProxy;
    }

    /**
     * Set the enableProxy property: Enable DNS Proxy on Firewalls attached to the Firewall Policy.
     *
     * @param enableProxy the enableProxy value to set.
     * @return the DnsSettings object itself.
     */
    public DnsSettings withEnableProxy(Boolean enableProxy) {
        this.enableProxy = enableProxy;
        return this;
    }

    /**
     * Get the requireProxyForNetworkRules property: FQDNs in Network Rules are supported when set to true.
     *
     * @return the requireProxyForNetworkRules value.
     */
    public Boolean requireProxyForNetworkRules() {
        return this.requireProxyForNetworkRules;
    }

    /**
     * Set the requireProxyForNetworkRules property: FQDNs in Network Rules are supported when set to true.
     *
     * @param requireProxyForNetworkRules the requireProxyForNetworkRules value to set.
     * @return the DnsSettings object itself.
     */
    public DnsSettings withRequireProxyForNetworkRules(Boolean requireProxyForNetworkRules) {
        this.requireProxyForNetworkRules = requireProxyForNetworkRules;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }
}
