// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.util.ExpandableStringEnum;
import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Collection;

/** Defines values for BastionConnectProtocol. */
public final class BastionConnectProtocol extends ExpandableStringEnum<BastionConnectProtocol> {
    /** Static value SSH for BastionConnectProtocol. */
    public static final BastionConnectProtocol SSH = fromString("SSH");

    /** Static value RDP for BastionConnectProtocol. */
    public static final BastionConnectProtocol RDP = fromString("RDP");

    /**
     * Creates or finds a BastionConnectProtocol from its string representation.
     *
     * @param name a name to look for.
     * @return the corresponding BastionConnectProtocol.
     */
    @JsonCreator
    public static BastionConnectProtocol fromString(String name) {
        return fromString(name, BastionConnectProtocol.class);
    }

    /** @return known BastionConnectProtocol values. */
    public static Collection<BastionConnectProtocol> values() {
        return values(BastionConnectProtocol.class);
    }
}
