// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.fluent.models.AzureWebCategoryInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Response for ListAzureWebCategories API service call. */
@Fluent
public final class AzureWebCategoryListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(AzureWebCategoryListResult.class);

    /*
     * List of Azure Web Categories for a given Subscription.
     */
    @JsonProperty(value = "value")
    private List<AzureWebCategoryInner> value;

    /*
     * URL to get the next set of results.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: List of Azure Web Categories for a given Subscription.
     *
     * @return the value value.
     */
    public List<AzureWebCategoryInner> value() {
        return this.value;
    }

    /**
     * Set the value property: List of Azure Web Categories for a given Subscription.
     *
     * @param value the value value to set.
     * @return the AzureWebCategoryListResult object itself.
     */
    public AzureWebCategoryListResult withValue(List<AzureWebCategoryInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: URL to get the next set of results.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: URL to get the next set of results.
     *
     * @param nextLink the nextLink value to set.
     * @return the AzureWebCategoryListResult object itself.
     */
    public AzureWebCategoryListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
