// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.azure.resourcemanager.network.models.RoutingPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The properties of a RoutingIntent resource. */
@Fluent
public final class RoutingIntentProperties {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(RoutingIntentProperties.class);

    /*
     * List of routing policies.
     */
    @JsonProperty(value = "routingPolicies")
    private List<RoutingPolicy> routingPolicies;

    /*
     * The provisioning state of the RoutingIntent resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the routingPolicies property: List of routing policies.
     *
     * @return the routingPolicies value.
     */
    public List<RoutingPolicy> routingPolicies() {
        return this.routingPolicies;
    }

    /**
     * Set the routingPolicies property: List of routing policies.
     *
     * @param routingPolicies the routingPolicies value to set.
     * @return the RoutingIntentProperties object itself.
     */
    public RoutingIntentProperties withRoutingPolicies(List<RoutingPolicy> routingPolicies) {
        this.routingPolicies = routingPolicies;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the RoutingIntent resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (routingPolicies() != null) {
            routingPolicies().forEach(e -> e.validate());
        }
    }
}
