// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;

/** IP configuration profile properties. */
@Fluent
public final class IpConfigurationProfilePropertiesFormatInner {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(IpConfigurationProfilePropertiesFormatInner.class);

    /*
     * The reference to the subnet resource to create a container network
     * interface ip configuration.
     */
    @JsonProperty(value = "subnet")
    private SubnetInner subnet;

    /*
     * The provisioning state of the IP configuration profile resource.
     */
    @JsonProperty(value = "provisioningState", access = JsonProperty.Access.WRITE_ONLY)
    private ProvisioningState provisioningState;

    /**
     * Get the subnet property: The reference to the subnet resource to create a container network interface ip
     * configuration.
     *
     * @return the subnet value.
     */
    public SubnetInner subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The reference to the subnet resource to create a container network interface ip
     * configuration.
     *
     * @param subnet the subnet value to set.
     * @return the IpConfigurationProfilePropertiesFormatInner object itself.
     */
    public IpConfigurationProfilePropertiesFormatInner withSubnet(SubnetInner subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the IP configuration profile resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
    }
}
