// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.InboundSecurityRules;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** NVA Inbound Security Rule resource. */
@Fluent
public final class InboundSecurityRuleInner extends SubResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(InboundSecurityRuleInner.class);

    /*
     * The properties of the Inbound Security Rules.
     */
    @JsonProperty(value = "properties")
    private InboundSecurityRuleProperties innerProperties;

    /*
     * Name of security rule collection.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * NVA inbound security rule type.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the innerProperties property: The properties of the Inbound Security Rules.
     *
     * @return the innerProperties value.
     */
    private InboundSecurityRuleProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of security rule collection.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of security rule collection.
     *
     * @param name the name value to set.
     * @return the InboundSecurityRuleInner object itself.
     */
    public InboundSecurityRuleInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: NVA inbound security rule type.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public InboundSecurityRuleInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the rules property: List of allowed rules.
     *
     * @return the rules value.
     */
    public List<InboundSecurityRules> rules() {
        return this.innerProperties() == null ? null : this.innerProperties().rules();
    }

    /**
     * Set the rules property: List of allowed rules.
     *
     * @param rules the rules value to set.
     * @return the InboundSecurityRuleInner object itself.
     */
    public InboundSecurityRuleInner withRules(List<InboundSecurityRules> rules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new InboundSecurityRuleProperties();
        }
        this.innerProperties().withRules(rules);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
