// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.network.models.ProvisioningState;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** UrlPathMaps give a url path to the backend mapping information for PathBasedRouting. */
@Fluent
public final class ApplicationGatewayUrlPathMapInner extends SubResource {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(ApplicationGatewayUrlPathMapInner.class);

    /*
     * Properties of the application gateway URL path map.
     */
    @JsonProperty(value = "properties")
    private ApplicationGatewayUrlPathMapPropertiesFormat innerProperties;

    /*
     * Name of the URL path map that is unique within an Application Gateway.
     */
    @JsonProperty(value = "name")
    private String name;

    /*
     * A unique read-only string that changes whenever the resource is updated.
     */
    @JsonProperty(value = "etag", access = JsonProperty.Access.WRITE_ONLY)
    private String etag;

    /*
     * Type of the resource.
     */
    @JsonProperty(value = "type", access = JsonProperty.Access.WRITE_ONLY)
    private String type;

    /**
     * Get the innerProperties property: Properties of the application gateway URL path map.
     *
     * @return the innerProperties value.
     */
    private ApplicationGatewayUrlPathMapPropertiesFormat innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the name property: Name of the URL path map that is unique within an Application Gateway.
     *
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the URL path map that is unique within an Application Gateway.
     *
     * @param name the name value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the etag property: A unique read-only string that changes whenever the resource is updated.
     *
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: Type of the resource.
     *
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /** {@inheritDoc} */
    @Override
    public ApplicationGatewayUrlPathMapInner withId(String id) {
        super.withId(id);
        return this;
    }

    /**
     * Get the defaultBackendAddressPool property: Default backend address pool resource of URL path map.
     *
     * @return the defaultBackendAddressPool value.
     */
    public SubResource defaultBackendAddressPool() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultBackendAddressPool();
    }

    /**
     * Set the defaultBackendAddressPool property: Default backend address pool resource of URL path map.
     *
     * @param defaultBackendAddressPool the defaultBackendAddressPool value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withDefaultBackendAddressPool(SubResource defaultBackendAddressPool) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayUrlPathMapPropertiesFormat();
        }
        this.innerProperties().withDefaultBackendAddressPool(defaultBackendAddressPool);
        return this;
    }

    /**
     * Get the defaultBackendHttpSettings property: Default backend http settings resource of URL path map.
     *
     * @return the defaultBackendHttpSettings value.
     */
    public SubResource defaultBackendHttpSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultBackendHttpSettings();
    }

    /**
     * Set the defaultBackendHttpSettings property: Default backend http settings resource of URL path map.
     *
     * @param defaultBackendHttpSettings the defaultBackendHttpSettings value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withDefaultBackendHttpSettings(SubResource defaultBackendHttpSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayUrlPathMapPropertiesFormat();
        }
        this.innerProperties().withDefaultBackendHttpSettings(defaultBackendHttpSettings);
        return this;
    }

    /**
     * Get the defaultRewriteRuleSet property: Default Rewrite rule set resource of URL path map.
     *
     * @return the defaultRewriteRuleSet value.
     */
    public SubResource defaultRewriteRuleSet() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultRewriteRuleSet();
    }

    /**
     * Set the defaultRewriteRuleSet property: Default Rewrite rule set resource of URL path map.
     *
     * @param defaultRewriteRuleSet the defaultRewriteRuleSet value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withDefaultRewriteRuleSet(SubResource defaultRewriteRuleSet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayUrlPathMapPropertiesFormat();
        }
        this.innerProperties().withDefaultRewriteRuleSet(defaultRewriteRuleSet);
        return this;
    }

    /**
     * Get the defaultRedirectConfiguration property: Default redirect configuration resource of URL path map.
     *
     * @return the defaultRedirectConfiguration value.
     */
    public SubResource defaultRedirectConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultRedirectConfiguration();
    }

    /**
     * Set the defaultRedirectConfiguration property: Default redirect configuration resource of URL path map.
     *
     * @param defaultRedirectConfiguration the defaultRedirectConfiguration value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withDefaultRedirectConfiguration(
        SubResource defaultRedirectConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayUrlPathMapPropertiesFormat();
        }
        this.innerProperties().withDefaultRedirectConfiguration(defaultRedirectConfiguration);
        return this;
    }

    /**
     * Get the defaultLoadDistributionPolicy property: Default Load Distribution Policy resource of URL path map.
     *
     * @return the defaultLoadDistributionPolicy value.
     */
    public SubResource defaultLoadDistributionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().defaultLoadDistributionPolicy();
    }

    /**
     * Set the defaultLoadDistributionPolicy property: Default Load Distribution Policy resource of URL path map.
     *
     * @param defaultLoadDistributionPolicy the defaultLoadDistributionPolicy value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withDefaultLoadDistributionPolicy(
        SubResource defaultLoadDistributionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayUrlPathMapPropertiesFormat();
        }
        this.innerProperties().withDefaultLoadDistributionPolicy(defaultLoadDistributionPolicy);
        return this;
    }

    /**
     * Get the pathRules property: Path rule of URL path map resource.
     *
     * @return the pathRules value.
     */
    public List<ApplicationGatewayPathRuleInner> pathRules() {
        return this.innerProperties() == null ? null : this.innerProperties().pathRules();
    }

    /**
     * Set the pathRules property: Path rule of URL path map resource.
     *
     * @param pathRules the pathRules value to set.
     * @return the ApplicationGatewayUrlPathMapInner object itself.
     */
    public ApplicationGatewayUrlPathMapInner withPathRules(List<ApplicationGatewayPathRuleInner> pathRules) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApplicationGatewayUrlPathMapPropertiesFormat();
        }
        this.innerProperties().withPathRules(pathRules);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state of the URL path map resource.
     *
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
