// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.network.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.network.fluent.models.NetworkVirtualApplianceSkuInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in VirtualApplianceSkusClient. */
public interface VirtualApplianceSkusClient {
    /**
     * List all SKUs available for a virtual appliance.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListNetworkVirtualApplianceSkus API service call as paginated response with {@link
     *     PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedFlux<NetworkVirtualApplianceSkuInner> listAsync();

    /**
     * List all SKUs available for a virtual appliance.
     *
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListNetworkVirtualApplianceSkus API service call as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkVirtualApplianceSkuInner> list();

    /**
     * List all SKUs available for a virtual appliance.
     *
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response for ListNetworkVirtualApplianceSkus API service call as paginated response with {@link
     *     PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    PagedIterable<NetworkVirtualApplianceSkuInner> list(Context context);

    /**
     * Retrieves a single available sku for network virtual appliance.
     *
     * @param skuName Name of the Sku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return available NetworkVirtualApplianceSkus along with {@link Response} on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<NetworkVirtualApplianceSkuInner>> getWithResponseAsync(String skuName);

    /**
     * Retrieves a single available sku for network virtual appliance.
     *
     * @param skuName Name of the Sku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return available NetworkVirtualApplianceSkus on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<NetworkVirtualApplianceSkuInner> getAsync(String skuName);

    /**
     * Retrieves a single available sku for network virtual appliance.
     *
     * @param skuName Name of the Sku.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return available NetworkVirtualApplianceSkus.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    NetworkVirtualApplianceSkuInner get(String skuName);

    /**
     * Retrieves a single available sku for network virtual appliance.
     *
     * @param skuName Name of the Sku.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return available NetworkVirtualApplianceSkus along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<NetworkVirtualApplianceSkuInner> getWithResponse(String skuName, Context context);
}
