// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes a federated identity credential.
 */
@Fluent
public final class FederatedIdentityCredentialInner extends ProxyResource {
    /*
     * The properties associated with the federated identity credential.
     */
    private FederatedIdentityCredentialProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of FederatedIdentityCredentialInner class.
     */
    public FederatedIdentityCredentialInner() {
    }

    /**
     * Get the innerProperties property: The properties associated with the federated identity credential.
     * 
     * @return the innerProperties value.
     */
    private FederatedIdentityCredentialProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the issuer property: The URL of the issuer to be trusted.
     * 
     * @return the issuer value.
     */
    public String issuer() {
        return this.innerProperties() == null ? null : this.innerProperties().issuer();
    }

    /**
     * Set the issuer property: The URL of the issuer to be trusted.
     * 
     * @param issuer the issuer value to set.
     * @return the FederatedIdentityCredentialInner object itself.
     */
    public FederatedIdentityCredentialInner withIssuer(String issuer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withIssuer(issuer);
        return this;
    }

    /**
     * Get the subject property: The identifier of the external identity.
     * 
     * @return the subject value.
     */
    public String subject() {
        return this.innerProperties() == null ? null : this.innerProperties().subject();
    }

    /**
     * Set the subject property: The identifier of the external identity.
     * 
     * @param subject the subject value to set.
     * @return the FederatedIdentityCredentialInner object itself.
     */
    public FederatedIdentityCredentialInner withSubject(String subject) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withSubject(subject);
        return this;
    }

    /**
     * Get the audiences property: The list of audiences that can appear in the issued token.
     * 
     * @return the audiences value.
     */
    public List<String> audiences() {
        return this.innerProperties() == null ? null : this.innerProperties().audiences();
    }

    /**
     * Set the audiences property: The list of audiences that can appear in the issued token.
     * 
     * @param audiences the audiences value to set.
     * @return the FederatedIdentityCredentialInner object itself.
     */
    public FederatedIdentityCredentialInner withAudiences(List<String> audiences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withAudiences(audiences);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of FederatedIdentityCredentialInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of FederatedIdentityCredentialInner if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the FederatedIdentityCredentialInner.
     */
    public static FederatedIdentityCredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FederatedIdentityCredentialInner deserializedFederatedIdentityCredentialInner
                = new FederatedIdentityCredentialInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.innerProperties
                        = FederatedIdentityCredentialProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedFederatedIdentityCredentialInner;
        });
    }
}
