// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Enum to configure regional restrictions on identity assignment, as necessary.
 */
public final class IsolationScope extends ExpandableStringEnum<IsolationScope> {
    /**
     * Static value None for IsolationScope.
     */
    public static final IsolationScope NONE = fromString("None");

    /**
     * Static value Regional for IsolationScope.
     */
    public static final IsolationScope REGIONAL = fromString("Regional");

    /**
     * Creates a new instance of IsolationScope value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public IsolationScope() {
    }

    /**
     * Creates or finds a IsolationScope from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding IsolationScope.
     */
    public static IsolationScope fromString(String name) {
        return fromString(name, IsolationScope.class);
    }

    /**
     * Gets known IsolationScope values.
     * 
     * @return known IsolationScope values.
     */
    public static Collection<IsolationScope> values() {
        return values(IsolationScope.class);
    }
}
