// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.models.IsolationScope;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

/**
 * Describes an identity resource.
 */
@Fluent
public final class IdentityInner extends Resource {
    /*
     * The properties associated with the identity.
     */
    private UserAssignedIdentityProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    private SystemData systemData;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of IdentityInner class.
     */
    public IdentityInner() {
    }

    /**
     * Get the innerProperties property: The properties associated with the identity.
     * 
     * @return the innerProperties value.
     */
    private UserAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     * 
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IdentityInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public IdentityInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the tenantId property: The id of the tenant which the identity belongs to.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    /**
     * Get the principalId property: The id of the service principal object associated with the created identity.
     * 
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    /**
     * Get the clientId property: The id of the app associated with the identity. This is a random generated UUID by
     * MSI.
     * 
     * @return the clientId value.
     */
    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    /**
     * Get the isolationScope property: Enum to configure regional restrictions on identity assignment, as necessary.
     * 
     * @return the isolationScope value.
     */
    public IsolationScope isolationScope() {
        return this.innerProperties() == null ? null : this.innerProperties().isolationScope();
    }

    /**
     * Set the isolationScope property: Enum to configure regional restrictions on identity assignment, as necessary.
     * 
     * @param isolationScope the isolationScope value to set.
     * @return the IdentityInner object itself.
     */
    public IdentityInner withIsolationScope(IsolationScope isolationScope) {
        if (this.innerProperties() == null) {
            this.innerProperties = new UserAssignedIdentityProperties();
        }
        this.innerProperties().withIsolationScope(isolationScope);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of IdentityInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of IdentityInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the IdentityInner.
     */
    public static IdentityInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            IdentityInner deserializedIdentityInner = new IdentityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedIdentityInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedIdentityInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedIdentityInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedIdentityInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedIdentityInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedIdentityInner.innerProperties = UserAssignedIdentityProperties.fromJson(reader);
                } else if ("systemData".equals(fieldName)) {
                    deserializedIdentityInner.systemData = SystemData.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedIdentityInner;
        });
    }
}
