/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.fluent.models.FederatedIdentityCredentialProperties;
import java.io.IOException;
import java.util.List;

public final class FederatedIdentityCredentialInner
extends ProxyResource {
    private FederatedIdentityCredentialProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;

    private FederatedIdentityCredentialProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public String issuer() {
        return this.innerProperties() == null ? null : this.innerProperties().issuer();
    }

    public FederatedIdentityCredentialInner withIssuer(String issuer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withIssuer(issuer);
        return this;
    }

    public String subject() {
        return this.innerProperties() == null ? null : this.innerProperties().subject();
    }

    public FederatedIdentityCredentialInner withSubject(String subject) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withSubject(subject);
        return this;
    }

    public List<String> audiences() {
        return this.innerProperties() == null ? null : this.innerProperties().audiences();
    }

    public FederatedIdentityCredentialInner withAudiences(List<String> audiences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withAudiences(audiences);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static FederatedIdentityCredentialInner fromJson(JsonReader jsonReader) throws IOException {
        return (FederatedIdentityCredentialInner)((Object)jsonReader.readObject(reader -> {
            FederatedIdentityCredentialInner deserializedFederatedIdentityCredentialInner = new FederatedIdentityCredentialInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.innerProperties = FederatedIdentityCredentialProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedFederatedIdentityCredentialInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedFederatedIdentityCredentialInner;
        }));
    }
}

