/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.exception.ManagementException;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.resourcemanager.msi.fluent.FederatedIdentityCredentialsClient;
import com.azure.resourcemanager.msi.fluent.models.FederatedIdentityCredentialInner;
import com.azure.resourcemanager.msi.implementation.ManagedServiceIdentityClientImpl;
import com.azure.resourcemanager.msi.models.FederatedIdentityCredentialsListResult;
import reactor.core.publisher.Mono;

public final class FederatedIdentityCredentialsClientImpl
implements FederatedIdentityCredentialsClient {
    private final FederatedIdentityCredentialsService service;
    private final ManagedServiceIdentityClientImpl client;

    FederatedIdentityCredentialsClientImpl(ManagedServiceIdentityClientImpl client) {
        this.service = (FederatedIdentityCredentialsService)RestProxy.create(FederatedIdentityCredentialsService.class, (HttpPipeline)client.getHttpPipeline(), (SerializerAdapter)client.getSerializerAdapter());
        this.client = client;
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FederatedIdentityCredentialInner>> listSinglePageAsync(String resourceGroupName, String resourceName, Integer top, String skiptoken) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, top, skiptoken, this.client.getApiVersion(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FederatedIdentityCredentialsListResult)res.getValue()).value(), ((FederatedIdentityCredentialsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FederatedIdentityCredentialInner>> listSinglePageAsync(String resourceGroupName, String resourceName, Integer top, String skiptoken, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.list(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, top, skiptoken, this.client.getApiVersion(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FederatedIdentityCredentialsListResult)res.getValue()).value(), ((FederatedIdentityCredentialsListResult)res.getValue()).nextLink(), null));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FederatedIdentityCredentialInner> listAsync(String resourceGroupName, String resourceName, Integer top, String skiptoken) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, top, skiptoken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<FederatedIdentityCredentialInner> listAsync(String resourceGroupName, String resourceName) {
        Integer top = null;
        String skiptoken = null;
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, top, skiptoken), nextLink -> this.listNextSinglePageAsync((String)nextLink));
    }

    @ServiceMethod(returns=ReturnType.COLLECTION)
    private PagedFlux<FederatedIdentityCredentialInner> listAsync(String resourceGroupName, String resourceName, Integer top, String skiptoken, Context context) {
        return new PagedFlux(() -> this.listSinglePageAsync(resourceGroupName, resourceName, top, skiptoken, context), nextLink -> this.listNextSinglePageAsync((String)nextLink, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FederatedIdentityCredentialInner> list(String resourceGroupName, String resourceName) {
        Integer top = null;
        String skiptoken = null;
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, top, skiptoken));
    }

    @Override
    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<FederatedIdentityCredentialInner> list(String resourceGroupName, String resourceName, Integer top, String skiptoken, Context context) {
        return new PagedIterable(this.listAsync(resourceGroupName, resourceName, top, skiptoken, context));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FederatedIdentityCredentialInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, FederatedIdentityCredentialInner parameters) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (federatedIdentityCredentialResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter federatedIdentityCredentialResourceName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, federatedIdentityCredentialResourceName, this.client.getApiVersion(), parameters, "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FederatedIdentityCredentialInner>> createOrUpdateWithResponseAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, FederatedIdentityCredentialInner parameters, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (federatedIdentityCredentialResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter federatedIdentityCredentialResourceName is required and cannot be null."));
        }
        if (parameters == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter parameters is required and cannot be null."));
        }
        parameters.validate();
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, federatedIdentityCredentialResourceName, this.client.getApiVersion(), parameters, "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FederatedIdentityCredentialInner> createOrUpdateAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, FederatedIdentityCredentialInner parameters) {
        return this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, parameters).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FederatedIdentityCredentialInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FederatedIdentityCredentialInner> createOrUpdateWithResponse(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, FederatedIdentityCredentialInner parameters, Context context) {
        return (Response)this.createOrUpdateWithResponseAsync(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, parameters, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FederatedIdentityCredentialInner createOrUpdate(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, FederatedIdentityCredentialInner parameters) {
        return (FederatedIdentityCredentialInner)((Object)this.createOrUpdateWithResponse(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, parameters, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<FederatedIdentityCredentialInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (federatedIdentityCredentialResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter federatedIdentityCredentialResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, federatedIdentityCredentialResourceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<FederatedIdentityCredentialInner>> getWithResponseAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (federatedIdentityCredentialResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter federatedIdentityCredentialResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, federatedIdentityCredentialResourceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<FederatedIdentityCredentialInner> getAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName) {
        return this.getWithResponseAsync(resourceGroupName, resourceName, federatedIdentityCredentialResourceName).flatMap(res -> Mono.justOrEmpty((Object)((Object)((FederatedIdentityCredentialInner)((Object)((Object)res.getValue()))))));
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<FederatedIdentityCredentialInner> getWithResponse(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, Context context) {
        return (Response)this.getWithResponseAsync(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public FederatedIdentityCredentialInner get(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName) {
        return (FederatedIdentityCredentialInner)((Object)this.getWithResponse(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, Context.NONE).getValue());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (federatedIdentityCredentialResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter federatedIdentityCredentialResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, federatedIdentityCredentialResourceName, this.client.getApiVersion(), "application/json", (Context)context)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<Response<Void>> deleteWithResponseAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (resourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter resourceName is required and cannot be null."));
        }
        if (federatedIdentityCredentialResourceName == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter federatedIdentityCredentialResourceName is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, resourceName, federatedIdentityCredentialResourceName, this.client.getApiVersion(), "application/json", context);
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName) {
        return this.deleteWithResponseAsync(resourceGroupName, resourceName, federatedIdentityCredentialResourceName).flatMap(ignored -> Mono.empty());
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName, Context context) {
        return (Response)this.deleteWithResponseAsync(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, context).block();
    }

    @Override
    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String resourceGroupName, String resourceName, String federatedIdentityCredentialResourceName) {
        this.deleteWithResponse(resourceGroupName, resourceName, federatedIdentityCredentialResourceName, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FederatedIdentityCredentialInner>> listNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        return FluxUtil.withContext(context -> this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", (Context)context)).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FederatedIdentityCredentialsListResult)res.getValue()).value(), ((FederatedIdentityCredentialsListResult)res.getValue()).nextLink(), null)).contextWrite(context -> context.putAll(FluxUtil.toReactorContext((Context)this.client.getContext()).readOnly()));
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    private Mono<PagedResponse<FederatedIdentityCredentialInner>> listNextSinglePageAsync(String nextLink, Context context) {
        if (nextLink == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error((Throwable)new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        String accept = "application/json";
        context = this.client.mergeContext(context);
        return this.service.listNext(nextLink, this.client.getEndpoint(), "application/json", context).map(res -> new PagedResponseBase(res.getRequest(), res.getStatusCode(), res.getHeaders(), ((FederatedIdentityCredentialsListResult)res.getValue()).value(), ((FederatedIdentityCredentialsListResult)res.getValue()).nextLink(), null));
    }

    @Host(value="{$host}")
    @ServiceInterface(name="ManagedServiceIdentityClientFederatedIdentityCredentials")
    public static interface FederatedIdentityCredentialsService {
        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FederatedIdentityCredentialsListResult>> list(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @QueryParam(value="$top") Integer var5, @QueryParam(value="$skiptoken") String var6, @QueryParam(value="api-version") String var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Put(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}")
        @ExpectedResponses(value={200, 201})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FederatedIdentityCredentialInner>> createOrUpdate(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="federatedIdentityCredentialResourceName") String var5, @QueryParam(value="api-version") String var6, @BodyParam(value="application/json") FederatedIdentityCredentialInner var7, @HeaderParam(value="Accept") String var8, Context var9);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FederatedIdentityCredentialInner>> get(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="federatedIdentityCredentialResourceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Delete(value="/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{resourceName}/federatedIdentityCredentials/{federatedIdentityCredentialResourceName}")
        @ExpectedResponses(value={200, 204})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<Void>> delete(@HostParam(value="$host") String var1, @PathParam(value="subscriptionId") String var2, @PathParam(value="resourceGroupName") String var3, @PathParam(value="resourceName") String var4, @PathParam(value="federatedIdentityCredentialResourceName") String var5, @QueryParam(value="api-version") String var6, @HeaderParam(value="Accept") String var7, Context var8);

        @Headers(value={"Content-Type: application/json"})
        @Get(value="{nextLink}")
        @ExpectedResponses(value={200})
        @UnexpectedResponseExceptionType(value=ManagementException.class)
        public Mono<Response<FederatedIdentityCredentialsListResult>> listNext(@PathParam(value="nextLink", encoded=true) String var1, @HostParam(value="$host") String var2, @HeaderParam(value="Accept") String var3, Context var4);
    }
}

