/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.fluent.models.SystemAssignedIdentityProperties;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public final class SystemAssignedIdentityInner
extends ProxyResource {
    private String location;
    private Map<String, String> tags;
    private SystemAssignedIdentityProperties innerProperties;
    private SystemData systemData;
    private String type;
    private String name;
    private String id;
    private static final ClientLogger LOGGER = new ClientLogger(SystemAssignedIdentityInner.class);

    public String location() {
        return this.location;
    }

    public SystemAssignedIdentityInner withLocation(String location) {
        this.location = location;
        return this;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public SystemAssignedIdentityInner withTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    private SystemAssignedIdentityProperties innerProperties() {
        return this.innerProperties;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public String type() {
        return this.type;
    }

    public String name() {
        return this.name;
    }

    public String id() {
        return this.id;
    }

    public UUID tenantId() {
        return this.innerProperties() == null ? null : this.innerProperties().tenantId();
    }

    public UUID principalId() {
        return this.innerProperties() == null ? null : this.innerProperties().principalId();
    }

    public UUID clientId() {
        return this.innerProperties() == null ? null : this.innerProperties().clientId();
    }

    public String clientSecretUrl() {
        return this.innerProperties() == null ? null : this.innerProperties().clientSecretUrl();
    }

    public void validate() {
        if (this.location() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property location in model SystemAssignedIdentityInner"));
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location);
        jsonWriter.writeMapField("tags", this.tags, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static SystemAssignedIdentityInner fromJson(JsonReader jsonReader) throws IOException {
        return (SystemAssignedIdentityInner)((Object)jsonReader.readObject(reader -> {
            SystemAssignedIdentityInner deserializedSystemAssignedIdentityInner = new SystemAssignedIdentityInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSystemAssignedIdentityInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedSystemAssignedIdentityInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedSystemAssignedIdentityInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedSystemAssignedIdentityInner.location = reader.getString();
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags;
                    deserializedSystemAssignedIdentityInner.tags = tags = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedSystemAssignedIdentityInner.innerProperties = SystemAssignedIdentityProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedSystemAssignedIdentityInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSystemAssignedIdentityInner;
        }));
    }
}

