// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.msi.fluent.models.IdentityInner;
import java.io.IOException;
import java.util.List;

/**
 * Values returned by the List operation.
 */
@Fluent
public final class UserAssignedIdentitiesListResult implements JsonSerializable<UserAssignedIdentitiesListResult> {
    /*
     * The collection of userAssignedIdentities returned by the listing operation.
     */
    private List<IdentityInner> value;

    /*
     * The url to get the next page of results, if any.
     */
    private String nextLink;

    /**
     * Creates an instance of UserAssignedIdentitiesListResult class.
     */
    public UserAssignedIdentitiesListResult() {
    }

    /**
     * Get the value property: The collection of userAssignedIdentities returned by the listing operation.
     * 
     * @return the value value.
     */
    public List<IdentityInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of userAssignedIdentities returned by the listing operation.
     * 
     * @param value the value value to set.
     * @return the UserAssignedIdentitiesListResult object itself.
     */
    public UserAssignedIdentitiesListResult withValue(List<IdentityInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The url to get the next page of results, if any.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The url to get the next page of results, if any.
     * 
     * @param nextLink the nextLink value to set.
     * @return the UserAssignedIdentitiesListResult object itself.
     */
    public UserAssignedIdentitiesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of UserAssignedIdentitiesListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of UserAssignedIdentitiesListResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the UserAssignedIdentitiesListResult.
     */
    public static UserAssignedIdentitiesListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            UserAssignedIdentitiesListResult deserializedUserAssignedIdentitiesListResult
                = new UserAssignedIdentitiesListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<IdentityInner> value = reader.readArray(reader1 -> IdentityInner.fromJson(reader1));
                    deserializedUserAssignedIdentitiesListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedUserAssignedIdentitiesListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedUserAssignedIdentitiesListResult;
        });
    }
}
