// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.core.management.SystemData;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Describes a federated identity credential. */
@Fluent
public final class FederatedIdentityCredentialInner extends ProxyResource {
    /*
     * Federated identity credential properties.
     *
     * The properties associated with the federated identity credential.
     */
    @JsonProperty(value = "properties")
    private FederatedIdentityCredentialProperties innerProperties;

    /*
     * Azure Resource Manager metadata containing createdBy and modifiedBy information.
     */
    @JsonProperty(value = "systemData", access = JsonProperty.Access.WRITE_ONLY)
    private SystemData systemData;

    /** Creates an instance of FederatedIdentityCredentialInner class. */
    public FederatedIdentityCredentialInner() {
    }

    /**
     * Get the innerProperties property: Federated identity credential properties.
     *
     * <p>The properties associated with the federated identity credential.
     *
     * @return the innerProperties value.
     */
    private FederatedIdentityCredentialProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the systemData property: Azure Resource Manager metadata containing createdBy and modifiedBy information.
     *
     * @return the systemData value.
     */
    public SystemData systemData() {
        return this.systemData;
    }

    /**
     * Get the issuer property: The URL of the issuer to be trusted.
     *
     * @return the issuer value.
     */
    public String issuer() {
        return this.innerProperties() == null ? null : this.innerProperties().issuer();
    }

    /**
     * Set the issuer property: The URL of the issuer to be trusted.
     *
     * @param issuer the issuer value to set.
     * @return the FederatedIdentityCredentialInner object itself.
     */
    public FederatedIdentityCredentialInner withIssuer(String issuer) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withIssuer(issuer);
        return this;
    }

    /**
     * Get the subject property: The identifier of the external identity.
     *
     * @return the subject value.
     */
    public String subject() {
        return this.innerProperties() == null ? null : this.innerProperties().subject();
    }

    /**
     * Set the subject property: The identifier of the external identity.
     *
     * @param subject the subject value to set.
     * @return the FederatedIdentityCredentialInner object itself.
     */
    public FederatedIdentityCredentialInner withSubject(String subject) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withSubject(subject);
        return this;
    }

    /**
     * Get the audiences property: The list of audiences that can appear in the issued token.
     *
     * @return the audiences value.
     */
    public List<String> audiences() {
        return this.innerProperties() == null ? null : this.innerProperties().audiences();
    }

    /**
     * Set the audiences property: The list of audiences that can appear in the issued token.
     *
     * @param audiences the audiences value to set.
     * @return the FederatedIdentityCredentialInner object itself.
     */
    public FederatedIdentityCredentialInner withAudiences(List<String> audiences) {
        if (this.innerProperties() == null) {
            this.innerProperties = new FederatedIdentityCredentialProperties();
        }
        this.innerProperties().withAudiences(audiences);
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }
}
