// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.resourcemanager.msi.fluent.models.SystemAssignedIdentityInner;
import reactor.core.publisher.Mono;

/** An instance of this class provides access to all the operations defined in SystemAssignedIdentitiesClient. */
public interface SystemAssignedIdentitiesClient {
    /**
     * Gets the systemAssignedIdentity available under the specified RP scope.
     *
     * @param scope The resource provider scope of the resource. Parent resource being extended by Managed Identities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the systemAssignedIdentity available under the specified RP scope along with {@link Response} on
     *     successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<Response<SystemAssignedIdentityInner>> getByScopeWithResponseAsync(String scope);

    /**
     * Gets the systemAssignedIdentity available under the specified RP scope.
     *
     * @param scope The resource provider scope of the resource. Parent resource being extended by Managed Identities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the systemAssignedIdentity available under the specified RP scope on successful completion of {@link
     *     Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Mono<SystemAssignedIdentityInner> getByScopeAsync(String scope);

    /**
     * Gets the systemAssignedIdentity available under the specified RP scope.
     *
     * @param scope The resource provider scope of the resource. Parent resource being extended by Managed Identities.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the systemAssignedIdentity available under the specified RP scope along with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    Response<SystemAssignedIdentityInner> getByScopeWithResponse(String scope, Context context);

    /**
     * Gets the systemAssignedIdentity available under the specified RP scope.
     *
     * @param scope The resource provider scope of the resource. Parent resource being extended by Managed Identities.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the systemAssignedIdentity available under the specified RP scope.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    SystemAssignedIdentityInner getByScope(String scope);
}
