// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.msi.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.msi.fluent.models.IdentityInner;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** Values returned by the List operation. */
@Fluent
public final class UserAssignedIdentitiesListResult {
    @JsonIgnore private final ClientLogger logger = new ClientLogger(UserAssignedIdentitiesListResult.class);

    /*
     * The collection of userAssignedIdentities returned by the listing
     * operation.
     */
    @JsonProperty(value = "value")
    private List<IdentityInner> value;

    /*
     * The url to get the next page of results, if any.
     */
    @JsonProperty(value = "nextLink")
    private String nextLink;

    /**
     * Get the value property: The collection of userAssignedIdentities returned by the listing operation.
     *
     * @return the value value.
     */
    public List<IdentityInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The collection of userAssignedIdentities returned by the listing operation.
     *
     * @param value the value value to set.
     * @return the UserAssignedIdentitiesListResult object itself.
     */
    public UserAssignedIdentitiesListResult withValue(List<IdentityInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The url to get the next page of results, if any.
     *
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The url to get the next page of results, if any.
     *
     * @param nextLink the nextLink value to set.
     * @return the UserAssignedIdentitiesListResult object itself.
     */
    public UserAssignedIdentitiesListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     *
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() != null) {
            value().forEach(e -> e.validate());
        }
    }
}
