/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ConditionOperator;
import com.azure.resourcemanager.monitor.models.RuleCondition;
import com.azure.resourcemanager.monitor.models.RuleDataSource;
import com.azure.resourcemanager.monitor.models.TimeAggregationOperator;
import java.io.IOException;
import java.time.Duration;

public final class ThresholdRuleCondition
extends RuleCondition {
    private String odataType = "Microsoft.Azure.Management.Insights.Models.ThresholdRuleCondition";
    private ConditionOperator operator;
    private double threshold;
    private Duration windowSize;
    private TimeAggregationOperator timeAggregation;
    private static final ClientLogger LOGGER = new ClientLogger(ThresholdRuleCondition.class);

    @Override
    public String odataType() {
        return this.odataType;
    }

    public ConditionOperator operator() {
        return this.operator;
    }

    public ThresholdRuleCondition withOperator(ConditionOperator operator) {
        this.operator = operator;
        return this;
    }

    public double threshold() {
        return this.threshold;
    }

    public ThresholdRuleCondition withThreshold(double threshold) {
        this.threshold = threshold;
        return this;
    }

    public Duration windowSize() {
        return this.windowSize;
    }

    public ThresholdRuleCondition withWindowSize(Duration windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    public TimeAggregationOperator timeAggregation() {
        return this.timeAggregation;
    }

    public ThresholdRuleCondition withTimeAggregation(TimeAggregationOperator timeAggregation) {
        this.timeAggregation = timeAggregation;
        return this;
    }

    @Override
    public ThresholdRuleCondition withDataSource(RuleDataSource dataSource) {
        super.withDataSource(dataSource);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model ThresholdRuleCondition"));
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("dataSource", (JsonSerializable)this.dataSource());
        jsonWriter.writeStringField("operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeDoubleField("threshold", this.threshold);
        jsonWriter.writeStringField("odata.type", this.odataType);
        jsonWriter.writeStringField("windowSize", CoreUtils.durationToStringWithDays((Duration)this.windowSize));
        jsonWriter.writeStringField("timeAggregation", this.timeAggregation == null ? null : this.timeAggregation.toString());
        return jsonWriter.writeEndObject();
    }

    public static ThresholdRuleCondition fromJson(JsonReader jsonReader) throws IOException {
        return (ThresholdRuleCondition)jsonReader.readObject(reader -> {
            ThresholdRuleCondition deserializedThresholdRuleCondition = new ThresholdRuleCondition();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("dataSource".equals(fieldName)) {
                    deserializedThresholdRuleCondition.withDataSource(RuleDataSource.fromJson(reader));
                    continue;
                }
                if ("operator".equals(fieldName)) {
                    deserializedThresholdRuleCondition.operator = ConditionOperator.fromString(reader.getString());
                    continue;
                }
                if ("threshold".equals(fieldName)) {
                    deserializedThresholdRuleCondition.threshold = reader.getDouble();
                    continue;
                }
                if ("odata.type".equals(fieldName)) {
                    deserializedThresholdRuleCondition.odataType = reader.getString();
                    continue;
                }
                if ("windowSize".equals(fieldName)) {
                    deserializedThresholdRuleCondition.windowSize = (Duration)reader.getNullable(nonNullReader -> Duration.parse(nonNullReader.getString()));
                    continue;
                }
                if ("timeAggregation".equals(fieldName)) {
                    deserializedThresholdRuleCondition.timeAggregation = TimeAggregationOperator.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedThresholdRuleCondition;
        });
    }
}

