/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ReceiverStatus;
import java.io.IOException;

public final class SmsReceiver
implements JsonSerializable<SmsReceiver> {
    private String name;
    private String countryCode;
    private String phoneNumber;
    private ReceiverStatus status;
    private static final ClientLogger LOGGER = new ClientLogger(SmsReceiver.class);

    public String name() {
        return this.name;
    }

    public SmsReceiver withName(String name) {
        this.name = name;
        return this;
    }

    public String countryCode() {
        return this.countryCode;
    }

    public SmsReceiver withCountryCode(String countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    public String phoneNumber() {
        return this.phoneNumber;
    }

    public SmsReceiver withPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    public ReceiverStatus status() {
        return this.status;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model SmsReceiver"));
        }
        if (this.countryCode() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property countryCode in model SmsReceiver"));
        }
        if (this.phoneNumber() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property phoneNumber in model SmsReceiver"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("countryCode", this.countryCode);
        jsonWriter.writeStringField("phoneNumber", this.phoneNumber);
        return jsonWriter.writeEndObject();
    }

    public static SmsReceiver fromJson(JsonReader jsonReader) throws IOException {
        return (SmsReceiver)jsonReader.readObject(reader -> {
            SmsReceiver deserializedSmsReceiver = new SmsReceiver();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedSmsReceiver.name = reader.getString();
                    continue;
                }
                if ("countryCode".equals(fieldName)) {
                    deserializedSmsReceiver.countryCode = reader.getString();
                    continue;
                }
                if ("phoneNumber".equals(fieldName)) {
                    deserializedSmsReceiver.phoneNumber = reader.getString();
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedSmsReceiver.status = ReceiverStatus.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSmsReceiver;
        });
    }
}

