/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.monitor.models.ScaleRuleMetricDimensionOperationType;
import java.io.IOException;
import java.util.List;

public final class ScaleRuleMetricDimension
implements JsonSerializable<ScaleRuleMetricDimension> {
    private String dimensionName;
    private ScaleRuleMetricDimensionOperationType operator;
    private List<String> values;
    private static final ClientLogger LOGGER = new ClientLogger(ScaleRuleMetricDimension.class);

    public String dimensionName() {
        return this.dimensionName;
    }

    public ScaleRuleMetricDimension withDimensionName(String dimensionName) {
        this.dimensionName = dimensionName;
        return this;
    }

    public ScaleRuleMetricDimensionOperationType operator() {
        return this.operator;
    }

    public ScaleRuleMetricDimension withOperator(ScaleRuleMetricDimensionOperationType operator) {
        this.operator = operator;
        return this;
    }

    public List<String> values() {
        return this.values;
    }

    public ScaleRuleMetricDimension withValues(List<String> values) {
        this.values = values;
        return this;
    }

    public void validate() {
        if (this.dimensionName() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property dimensionName in model ScaleRuleMetricDimension"));
        }
        if (this.operator() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property operator in model ScaleRuleMetricDimension"));
        }
        if (this.values() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property values in model ScaleRuleMetricDimension"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("DimensionName", this.dimensionName);
        jsonWriter.writeStringField("Operator", this.operator == null ? null : this.operator.toString());
        jsonWriter.writeArrayField("Values", this.values, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static ScaleRuleMetricDimension fromJson(JsonReader jsonReader) throws IOException {
        return (ScaleRuleMetricDimension)jsonReader.readObject(reader -> {
            ScaleRuleMetricDimension deserializedScaleRuleMetricDimension = new ScaleRuleMetricDimension();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DimensionName".equals(fieldName)) {
                    deserializedScaleRuleMetricDimension.dimensionName = reader.getString();
                    continue;
                }
                if ("Operator".equals(fieldName)) {
                    deserializedScaleRuleMetricDimension.operator = ScaleRuleMetricDimensionOperationType.fromString(reader.getString());
                    continue;
                }
                if ("Values".equals(fieldName)) {
                    List values;
                    deserializedScaleRuleMetricDimension.values = values = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedScaleRuleMetricDimension;
        });
    }
}

